/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.particle;

import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class MalachiteMagicParticle
extends TextureSheetParticle {
    protected MalachiteMagicParticle(ClientLevel world, double xPos, double yPos, double zPos, double xDist, double yDist, double zDist) {
        super(world, xPos, yPos, zPos, xDist, yDist, zDist);
        this.xd = xDist;
        this.yd = yDist + (double)(this.random.nextFloat() * 0.05f);
        this.zd = zDist;
        this.lifetime = this.random.nextInt(20) + 40;
        this.hasPhysics = false;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ < this.lifetime && !(this.alpha <= 0.0f)) {
            this.xd *= (double)0.9f;
            this.zd *= (double)0.9f;
            this.move(this.xd, this.yd, this.zd);
            if (this.age >= this.lifetime - 30 && this.alpha > 0.01f) {
                this.alpha -= 0.03f;
            }
        } else {
            this.remove();
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Factory(SpriteSet sprite) {
            this.sprite = sprite;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double xPos, double yPos, double zPos, double xDist, double yDist, double zDist) {
            MalachiteMagicParticle particle = new MalachiteMagicParticle(level, xPos, yPos, zPos, xDist, yDist, zDist);
            particle.pickSprite(this.sprite);
            return particle;
        }
    }
}

