/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.particle;

import java.util.Random;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class SpawnerCoreParticle
extends TextureSheetParticle {
    private static final Random RANDOM = new Random();

    public SpawnerCoreParticle(ClientLevel world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ, SpriteSet sprite) {
        super(world, posX, posY, posZ, 0.5 - RANDOM.nextDouble(), motionY, 0.5 - RANDOM.nextDouble());
        if (motionX == 0.0 && motionZ == 0.0) {
            this.xd *= (double)0.2f;
            this.zd *= (double)0.2f;
        }
        this.yd = 0.0;
        this.quadSize *= 0.75f;
        this.lifetime = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        this.hasPhysics = false;
        this.setSpriteFromAge(sprite);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public int getLightColor(float partialTicks) {
        return 0xF000F0;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.move(this.xd, this.yd, this.zd);
            if (this.y == this.yo) {
                this.xd *= 1.1;
                this.zd *= 1.1;
            }
            this.xd *= (double)0.96f;
            this.zd *= (double)0.96f;
            if (this.onGround) {
                this.xd *= (double)0.7f;
                this.zd *= (double)0.7f;
            }
        }
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double posX, double posY, double posZ, double r, double g, double b) {
            SpawnerCoreParticle particle = new SpawnerCoreParticle(world, posX, posY, posZ, r, g, b, this.spriteSet);
            particle.setColor((float)r, (float)g, (float)b);
            return particle;
        }
    }
}

