/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.registry.bootstrap;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.level.Level;

public class GaiaDamage {
    public static final ResourceKey<DamageType> ENERGETIC = GaiaDamage.makeDamage("energetic");
    public static final ResourceKey<DamageType> STATIC = GaiaDamage.makeDamage("static");
    public static final ResourceKey<DamageType> CORRUPTION = GaiaDamage.makeDamage("corruption");
    public static final ResourceKey<DamageType> MALACHITE_BLAST = GaiaDamage.makeDamage("malachite_blast");

    private static ResourceKey<DamageType> makeDamage(String name) {
        return ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)name));
    }

    public static DamageSource getDamage(Level level, ResourceKey<DamageType> damage) {
        return new DamageSource((Holder)level.registryAccess().lookupOrThrow(Registries.DAMAGE_TYPE).getOrThrow(damage));
    }

    public static void init(BootstrapContext<DamageType> context) {
        context.register(ENERGETIC, (Object)new DamageType("gaiadimension.energetic", 0.0f));
        context.register(STATIC, (Object)new DamageType("gaiadimension.static", 0.0f));
        context.register(CORRUPTION, (Object)new DamageType("gaiadimension.corruption", 0.0f));
        context.register(MALACHITE_BLAST, (Object)new DamageType("gaiadimension.malachiteBlast", 0.0f));
    }
}

