/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.registry.bootstrap;

import androsa.gaiadimension.data.GaiaBiomeMaker;
import androsa.gaiadimension.registry.registration.ModBlocks;
import androsa.gaiadimension.world.chunk.GaiaBiomeSource;
import androsa.gaiadimension.world.chunk.GaiaChunkGenerator;
import androsa.gaiadimension.world.chunk.GaiaSurfaceRuleData;
import java.util.List;
import java.util.OptionalLong;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;

public class GaiaDimensions {
    public static final ResourceKey<LevelStem> GAIA_DIMENSION_STEM = ResourceKey.create((ResourceKey)Registries.LEVEL_STEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)"gaia_dimension"));
    public static final ResourceKey<Level> gaia_world = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)"gaia_dimension"));
    public static final ResourceKey<DimensionType> gaia_dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)"gaia_dimension"));
    public static final ResourceKey<NoiseGeneratorSettings> gaia_noise = ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)"gaia_noise"));

    public static void initStem(BootstrapContext<LevelStem> context) {
        HolderGetter biomes = context.lookup(Registries.BIOME);
        HolderGetter noiseGens = context.lookup(Registries.NOISE_SETTINGS);
        HolderGetter dimTypes = context.lookup(Registries.DIMENSION_TYPE);
        GaiaBiomeSource source = new GaiaBiomeSource(GaiaBiomeMaker.makeBiomeList((HolderGetter<Biome>)biomes), 0.0f, 1.0f, (HolderGetter<Biome>)biomes);
        GaiaChunkGenerator chunkgen = new GaiaChunkGenerator(source, (Holder<NoiseGeneratorSettings>)noiseGens.getOrThrow(gaia_noise));
        LevelStem stem = new LevelStem((Holder)dimTypes.getOrThrow(gaia_dimension), (ChunkGenerator)chunkgen);
        context.register(GAIA_DIMENSION_STEM, (Object)stem);
    }

    public static void initType(BootstrapContext<DimensionType> context) {
        DimensionType.MonsterSettings monsters = new DimensionType.MonsterSettings(false, false, (IntProvider)UniformInt.of((int)0, (int)7), 7);
        DimensionType type = new DimensionType(OptionalLong.of(6000L), true, false, false, true, 1.0, true, true, -64, 320, 320, BlockTags.INFINIBURN_OVERWORLD, ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)"gaia"), 0.0f, monsters);
        context.register(gaia_dimension, (Object)type);
    }

    public static void initNoise(BootstrapContext<NoiseGeneratorSettings> context) {
        NoiseSettings noiseSettings = NoiseSettings.create((int)-64, (int)256, (int)1, (int)2);
        NoiseRouter noiseRouter = new NoiseRouter(DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero());
        NoiseGeneratorSettings noisegen = new NoiseGeneratorSettings(noiseSettings, ((Block)ModBlocks.gaia_stone.get()).defaultBlockState(), ((LiquidBlock)ModBlocks.mineral_water.get()).defaultBlockState(), noiseRouter, GaiaSurfaceRuleData.gaia(true, false, true), List.of(), 63, false, false, false, false);
        context.register(gaia_noise, (Object)noisegen);
    }
}

