/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.registry.registration;

import androsa.gaiadimension.registry.values.GaiaTags;
import androsa.gaiadimension.world.gen.structure.MalachiteWatchtowerStructure;
import androsa.gaiadimension.world.gen.structure.MiniTowerStructure;
import androsa.gaiadimension.world.gen.structure.pieces.MalachiteWatchtowerPieces;
import androsa.gaiadimension.world.gen.structure.pieces.MiniTowerPieces;
import androsa.gaiadimension.world.gen.structure.processor.BlockDegradeProcessor;
import androsa.gaiadimension.world.gen.structure.processor.MalachiteDegradeProcessor;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class ModStructures {
    public static final DeferredRegister<StructureType<?>> STRUCTURE_TYPES = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_TYPE, (String)"gaiadimension");
    public static final DeferredRegister<StructureProcessorType<?>> STRUCTURE_PROCESSORS = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_PROCESSOR, (String)"gaiadimension");
    public static final DeferredRegister<StructurePieceType> STRUCTURE_PIECES = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_PIECE, (String)"gaiadimension");
    public static final DeferredHolder<StructureType<?>, StructureType<MiniTowerStructure>> MINI_TOWER_TYPE = STRUCTURE_TYPES.register("mini_tower", () -> () -> MiniTowerStructure.CODEC);
    public static final DeferredHolder<StructureType<?>, StructureType<MalachiteWatchtowerStructure>> MALACHITE_WATCHTOWER_TYPE = STRUCTURE_TYPES.register("malachite_watchtower", () -> () -> MalachiteWatchtowerStructure.CODEC);
    public static final ResourceKey<Structure> MINI_TOWER = ModStructures.makeStructure("mini_tower");
    public static final ResourceKey<Structure> MALACHITE_WATCHTOWER = ModStructures.makeStructure("malachite_watchtower");
    public static final ResourceKey<StructureSet> MINI_TOWER_SET = ModStructures.makeSet("mini_tower");
    public static final ResourceKey<StructureSet> MALACHITE_WATCHTOWER_SET = ModStructures.makeSet("malachite_watchtower");
    public static final DeferredHolder<StructureProcessorType<?>, StructureProcessorType<BlockDegradeProcessor>> BLOCK_DEGRADE = STRUCTURE_PROCESSORS.register("block_degrade", () -> () -> BlockDegradeProcessor.CODEC);
    public static final DeferredHolder<StructureProcessorType<?>, StructureProcessorType<MalachiteDegradeProcessor>> MALACHITE_DEGRADE = STRUCTURE_PROCESSORS.register("malachite_degrade", () -> () -> MalachiteDegradeProcessor.CODEC);
    public static final DeferredHolder<StructurePieceType, StructurePieceType> MITO = STRUCTURE_PIECES.register("mito", ModStructures.piece(MiniTowerPieces.Piece::new));
    public static final DeferredHolder<StructurePieceType, StructurePieceType> MAWA = STRUCTURE_PIECES.register("mawa", ModStructures.piece(MalachiteWatchtowerPieces.Piece::new));

    private static ResourceKey<Structure> makeStructure(String name) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)name));
    }

    private static ResourceKey<StructureSet> makeSet(String name) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)name));
    }

    public static Supplier<StructurePieceType> piece(StructurePieceType.StructureTemplateType piece) {
        return () -> piece;
    }

    public static void initStructures(BootstrapContext<Structure> context) {
        HolderGetter biomes = context.lookup(Registries.BIOME);
        context.register(MINI_TOWER, (Object)new MiniTowerStructure(new Structure.StructureSettings((HolderSet)biomes.getOrThrow(GaiaTags.Biomes.HAS_MINI_TOWER), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE)));
        context.register(MALACHITE_WATCHTOWER, (Object)new MalachiteWatchtowerStructure(new Structure.StructureSettings((HolderSet)biomes.getOrThrow(GaiaTags.Biomes.HAS_MALACHITE_WATCHTOWER), MalachiteWatchtowerStructure.SPAWNS, GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE)));
    }

    public static void initSets(BootstrapContext<StructureSet> context) {
        HolderGetter structures = context.lookup(Registries.STRUCTURE);
        context.register(MINI_TOWER_SET, (Object)new StructureSet((Holder)structures.getOrThrow(MINI_TOWER), (StructurePlacement)new RandomSpreadStructurePlacement(30, 10, RandomSpreadType.LINEAR, 420)));
        context.register(MALACHITE_WATCHTOWER_SET, (Object)new StructureSet((Holder)structures.getOrThrow(MALACHITE_WATCHTOWER), (StructurePlacement)new RandomSpreadStructurePlacement(35, 15, RandomSpreadType.TRIANGULAR, 621)));
    }
}

