/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.registry.values;

import androsa.gaiadimension.entity.data.SapperVariant;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;

public class GaiaBuiltinTables {
    private static final Set<ResourceKey<LootTable>> BUILTIN = Sets.newHashSet();
    public static final Map<SapperVariant, ResourceKey<LootTable>> SAPPER_TABLES = (Map)Util.make(new EnumMap(SapperVariant.class), map -> {
        for (SapperVariant variant : SapperVariant.values()) {
            map.put(variant, GaiaBuiltinTables.makeTable("entities/" + variant.getVariant() + "_sapper"));
        }
    });

    private static ResourceKey<LootTable> makeTable(String path) {
        ResourceKey loc = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)path));
        if (BUILTIN.add((ResourceKey<LootTable>)loc)) {
            return loc;
        }
        throw new IllegalArgumentException(String.format("%s already exists as a built-in loot table!", loc));
    }

    public static Set<ResourceKey<LootTable>> builtin() {
        return Collections.unmodifiableSet(BUILTIN);
    }
}

