/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.registry.values;

import androsa.gaiadimension.registry.registration.ModBlocks;
import androsa.gaiadimension.registry.registration.ModFluids;
import androsa.gaiadimension.registry.registration.ModItems;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidInteractionRegistry;
import net.neoforged.neoforge.fluids.FluidType;

public class GaiaFluidAttributes {
    public static final ResourceLocation mineral_still = GaiaFluidAttributes.makePath("mineral_water", "still");
    public static final ResourceLocation mineral_flow = GaiaFluidAttributes.makePath("mineral_water", "flow");
    public static final ResourceLocation superhot_still = GaiaFluidAttributes.makePath("superhot_magma", "still");
    public static final ResourceLocation superhot_flow = GaiaFluidAttributes.makePath("superhot_magma", "flow");
    public static final ResourceLocation sweet_still = GaiaFluidAttributes.makePath("sweet_muck", "still");
    public static final ResourceLocation sweet_flow = GaiaFluidAttributes.makePath("sweet_muck", "flow");
    public static final ResourceLocation bismuth_still = GaiaFluidAttributes.makePath("liquid_bismuth", "still");
    public static final ResourceLocation bismuth_flow = GaiaFluidAttributes.makePath("liquid_bismuth", "flow");
    public static final ResourceLocation aura_still = GaiaFluidAttributes.makePath("liquid_aura", "still");
    public static final ResourceLocation aura_flow = GaiaFluidAttributes.makePath("liquid_aura", "flow");
    public static final FluidType.Properties mineral_water_attributes = FluidType.Properties.create().sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.FIRE_EXTINGUISH).canConvertToSource(true).canDrown(true).canExtinguish(true).canSwim(true).fallDistanceModifier(0.0f).supportsBoating(true).viscosity(750);
    public static final FluidType.Properties superhot_magma_attributes = FluidType.Properties.create().sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL_LAVA).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY_LAVA).density(4000).lightLevel(15).temperature(2000).viscosity(4000);
    public static final FluidType.Properties sweet_muck_attrubutes = FluidType.Properties.create().sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.FIRE_EXTINGUISH).canConvertToSource(true).density(1000).viscosity(750);
    public static final FluidType.Properties liquid_bismuth_attributes = FluidType.Properties.create().sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL_LAVA).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY_LAVA).density(2500).lightLevel(3).temperature(300).viscosity(3500);
    public static final FluidType.Properties liquid_aura_attributes = FluidType.Properties.create().sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.FIRE_EXTINGUISH).viscosity(1500);
    public static final Supplier<BaseFlowingFluid.Properties> mineral_water_properties = () -> new BaseFlowingFluid.Properties(() -> (FluidType)ModFluids.MINERAL_WATER.get(), () -> (Fluid)ModFluids.mineral_water_still.get(), () -> (Fluid)ModFluids.mineral_water_flow.get()).block(ModBlocks.mineral_water).bucket(ModItems.mineral_water_bucket).explosionResistance(100.0f);
    public static final Supplier<BaseFlowingFluid.Properties> superhot_magma_properties = () -> new BaseFlowingFluid.Properties(() -> (FluidType)ModFluids.SUPERHOT_MAGMA.get(), () -> (Fluid)ModFluids.superhot_magma_still.get(), () -> (Fluid)ModFluids.superhot_magma_flow.get()).block(ModBlocks.superhot_magma).bucket(ModItems.superhot_magma_bucket).explosionResistance(100.0f).slopeFindDistance(2).tickRate(30);
    public static final Supplier<BaseFlowingFluid.Properties> sweet_muck_properties = () -> new BaseFlowingFluid.Properties(() -> (FluidType)ModFluids.SWEET_MUCK.get(), () -> (Fluid)ModFluids.sweet_muck_still.get(), () -> (Fluid)ModFluids.sweet_muck_flow.get()).block(ModBlocks.sweet_muck).bucket(ModItems.sweet_muck_bucket).explosionResistance(100.0f).slopeFindDistance(2).tickRate(20);
    public static final Supplier<BaseFlowingFluid.Properties> liquid_bismuth_properties = () -> new BaseFlowingFluid.Properties(() -> (FluidType)ModFluids.LIQUID_BISMUTH.get(), () -> (Fluid)ModFluids.liquid_bismuth_still.get(), () -> (Fluid)ModFluids.liquid_bismuth_flow.get()).block(ModBlocks.liquid_bismuth).bucket(ModItems.liquid_bismuth_bucket).explosionResistance(100.0f).slopeFindDistance(3).tickRate(20);
    public static final Supplier<BaseFlowingFluid.Properties> liquid_aura_properties = () -> new BaseFlowingFluid.Properties(() -> (FluidType)ModFluids.LIQUID_AURA.get(), () -> (Fluid)ModFluids.liquid_aura_still.get(), () -> (Fluid)ModFluids.liquid_aura_flow.get()).block(ModBlocks.liquid_aura).bucket(ModItems.liquid_aura_bucket).explosionResistance(100.0f);

    private static ResourceLocation makePath(String name, String suffix) {
        return ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)String.format("block/fluids/%s/%s_%s", name, name, suffix));
    }

    public static void registerFluidInteractions() {
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)NeoForgeMod.LAVA_TYPE.value()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)ModFluids.MINERAL_WATER.get(), ((Block)ModBlocks.gaia_cobblestone.get()).defaultBlockState()));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)NeoForgeMod.LAVA_TYPE.value()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)ModFluids.SWEET_MUCK.get(), ((Block)ModBlocks.gaia_cobblestone.get()).defaultBlockState()));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)NeoForgeMod.LAVA_TYPE.value()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)ModFluids.LIQUID_AURA.get(), ((Block)ModBlocks.sparkling_rock.get()).defaultBlockState()));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ModFluids.SUPERHOT_MAGMA.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)NeoForgeMod.WATER_TYPE.value(), ((Block)ModBlocks.gaia_cobblestone.get()).defaultBlockState()));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ModFluids.SUPERHOT_MAGMA.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)ModFluids.MINERAL_WATER.get(), ((Block)ModBlocks.primal_mass.get()).defaultBlockState()));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ModFluids.SUPERHOT_MAGMA.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)ModFluids.SWEET_MUCK.get(), ((Block)ModBlocks.primal_mass.get()).defaultBlockState()));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ModFluids.SUPERHOT_MAGMA.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)ModFluids.LIQUID_AURA.get(), ((Block)ModBlocks.aura_block.get()).defaultBlockState()));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ModFluids.LIQUID_BISMUTH.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)NeoForgeMod.WATER_TYPE.value(), ((Block)ModBlocks.impure_rock.get()).defaultBlockState()));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ModFluids.LIQUID_BISMUTH.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)ModFluids.MINERAL_WATER.get(), ((Block)ModBlocks.active_rock.get()).defaultBlockState()));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ModFluids.LIQUID_BISMUTH.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)ModFluids.SWEET_MUCK.get(), ((Block)ModBlocks.active_rock.get()).defaultBlockState()));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ModFluids.LIQUID_BISMUTH.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)ModFluids.LIQUID_AURA.get(), ((Block)ModBlocks.bismuth_block.get()).defaultBlockState()));
    }
}

