/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.renderer;

import androsa.gaiadimension.entity.MineralArenthis;
import androsa.gaiadimension.model.MineralArenthisModel;
import androsa.gaiadimension.registry.helpers.ModEntitiesRendering;
import androsa.gaiadimension.renderer.layer.MineralArenthisPartsLayer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.SquidRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class MineralArenthisRenderer<T extends MineralArenthis, M extends MineralArenthisModel>
extends MobRenderer<T, SquidRenderState, M> {
    public MineralArenthisRenderer(EntityRendererProvider.Context manager, M model, float shadowSize) {
        super(manager, model, shadowSize);
        this.addLayer(new MineralArenthisPartsLayer(this));
    }

    public ResourceLocation getTextureLocation(SquidRenderState entity) {
        return ModEntitiesRendering.makeTexture("mineral_arenthis", "");
    }

    public SquidRenderState createRenderState() {
        return new SquidRenderState();
    }

    public void extractRenderState(T entity, SquidRenderState state, float partialTicks) {
        super.extractRenderState(entity, (LivingEntityRenderState)state, partialTicks);
        state.tentacleAngle = Mth.lerp((float)partialTicks, (float)((MineralArenthis)((Object)entity)).lastTentacleAngle, (float)((MineralArenthis)((Object)entity)).tentacleAngle);
        state.xBodyRot = Mth.lerp((float)partialTicks, (float)((MineralArenthis)((Object)entity)).prevArenthisPitch, (float)((MineralArenthis)((Object)entity)).arenthisPitch);
        state.zBodyRot = Mth.lerp((float)partialTicks, (float)((MineralArenthis)((Object)entity)).prevArenthisYaw, (float)((MineralArenthis)((Object)entity)).arenthisYaw);
    }

    protected void setupRotations(SquidRenderState entity, PoseStack matrixStack, float rotationPitch, float rotationYaw) {
        matrixStack.translate(0.0f, 0.5f, 0.0f);
        matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f - rotationYaw));
        matrixStack.mulPose(Axis.XP.rotationDegrees(entity.xBodyRot));
        matrixStack.mulPose(Axis.YP.rotationDegrees(entity.zBodyRot));
        matrixStack.translate(0.0f, -1.2f, 0.0f);
    }
}

