/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.renderer;

import androsa.gaiadimension.entity.Muckling;
import androsa.gaiadimension.registry.helpers.ModEntitiesRendering;
import androsa.gaiadimension.renderer.layer.MucklingOuterLayer;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SlimeModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.SlimeRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class MucklingRenderer
extends MobRenderer<Muckling, SlimeRenderState, SlimeModel> {
    public static final ResourceLocation LOCATION = ModEntitiesRendering.makeTexture("muckling");

    public MucklingRenderer(EntityRendererProvider.Context manager, float shadowSize) {
        super(manager, (EntityModel)new SlimeModel(manager.bakeLayer(ModelLayers.SLIME)), shadowSize);
        this.addLayer(new MucklingOuterLayer((RenderLayerParent<SlimeRenderState, SlimeModel>)this, manager.getModelSet()));
    }

    public SlimeRenderState createRenderState() {
        return new SlimeRenderState();
    }

    public void extractRenderState(Muckling entity, SlimeRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, (LivingEntityRenderState)state, partialTicks);
        state.squish = Mth.lerp((float)partialTicks, (float)entity.oSquish, (float)entity.squish);
        state.size = entity.getSize();
    }

    public ResourceLocation getTextureLocation(SlimeRenderState entity) {
        return LOCATION;
    }

    protected float getShadowRadius(SlimeRenderState state) {
        return (float)state.size * 0.25f;
    }

    protected void scale(SlimeRenderState state, PoseStack stack) {
        float size = state.size;
        float squishSize = state.squish / (size * 0.5f + 1.0f);
        float squishScale = 1.0f / (squishSize + 1.0f);
        stack.scale(squishScale * size, 1.0f / squishScale * size, squishScale * size);
    }
}

