/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.renderer;

import androsa.gaiadimension.entity.ShallowArenthis;
import androsa.gaiadimension.model.ShallowArenthisModel;
import androsa.gaiadimension.registry.helpers.ModEntitiesRendering;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.SquidRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ShallowArenthisRenderer<T extends ShallowArenthis, M extends ShallowArenthisModel>
extends MobRenderer<T, SquidRenderState, M> {
    public ShallowArenthisRenderer(EntityRendererProvider.Context manager, M model, float shadowSize) {
        super(manager, model, shadowSize);
    }

    public SquidRenderState createRenderState() {
        return new SquidRenderState();
    }

    public void extractRenderState(T entity, SquidRenderState state, float partialTicks) {
        super.extractRenderState(entity, (LivingEntityRenderState)state, partialTicks);
        state.tentacleAngle = Mth.lerp((float)partialTicks, (float)((ShallowArenthis)((Object)entity)).lastTentacleAngle, (float)((ShallowArenthis)((Object)entity)).tentacleAngle);
        state.xBodyRot = Mth.lerp((float)partialTicks, (float)((ShallowArenthis)((Object)entity)).prevArenthisPitch, (float)((ShallowArenthis)((Object)entity)).arenthisPitch);
        state.zBodyRot = Mth.lerp((float)partialTicks, (float)((ShallowArenthis)((Object)entity)).prevArenthisYaw, (float)((ShallowArenthis)((Object)entity)).arenthisYaw);
    }

    protected void setupRotations(SquidRenderState entity, PoseStack matrixStack, float rotationPitch, float rotationYaw) {
        matrixStack.translate(0.0f, 0.5f, 0.0f);
        matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f - rotationYaw));
        matrixStack.mulPose(Axis.XP.rotationDegrees(entity.xBodyRot));
        matrixStack.mulPose(Axis.YP.rotationDegrees(entity.zBodyRot));
        matrixStack.translate(0.0f, -1.2f, 0.0f);
    }

    public ResourceLocation getTextureLocation(SquidRenderState entity) {
        return ModEntitiesRendering.makeTexture("shallow_arenthis");
    }
}

