/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.renderer.layer;

import androsa.gaiadimension.entity.MookaiteConstruct;
import androsa.gaiadimension.entity.data.MookaitePartType;
import androsa.gaiadimension.model.MookaiteConstructModel;
import androsa.gaiadimension.model.renderstate.MookaiteConstructRenderState;
import androsa.gaiadimension.registry.helpers.ModEntitiesRendering;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;

public class MookaiteConstructPartLayer<M extends MookaiteConstructModel>
extends RenderLayer<MookaiteConstructRenderState, M> {
    public MookaiteConstructPartLayer(RenderLayerParent<MookaiteConstructRenderState, M> renderer) {
        super(renderer);
    }

    public void render(PoseStack stack, MultiBufferSource buffer, int light, MookaiteConstructRenderState state, float netHeadYaw, float headPitch) {
        for (Map.Entry<MookaiteConstruct.MookaitePart, MookaitePartType> part : state.partMap.entrySet()) {
            if (!part.getValue().isPresent()) continue;
            String color = part.getValue().getSerializedName();
            ResourceLocation location = ModEntitiesRendering.makeTextureNoPrefix("mookaite_construct", part.getKey().name() + "/" + color);
            if (location == null || state.isInvisible) continue;
            VertexConsumer vertex = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)location));
            ((MookaiteConstructModel)this.getParentModel()).renderToBuffer(stack, vertex, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
        }
    }
}

