/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.feature;

import androsa.gaiadimension.block.AuraShootBlock;
import androsa.gaiadimension.registry.registration.ModBlocks;
import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

@ParametersAreNonnullByDefault
public class AuraShootsFeature<T extends NoneFeatureConfiguration>
extends Feature<T> {
    private static final Supplier<BlockState> AURA_SHOOT = () -> ((Block)ModBlocks.aura_shoot.get()).defaultBlockState();

    public AuraShootsFeature(Codec<T> configIn) {
        super(configIn);
    }

    public boolean place(FeaturePlaceContext<T> context) {
        return this.place(context.level(), context.random(), context.origin());
    }

    public boolean place(WorldGenLevel worldIn, RandomSource rand, BlockPos position) {
        for (int i = 0; i < 20; ++i) {
            BlockPos blockpos = position.offset(rand.nextInt(4) - rand.nextInt(4), 0, rand.nextInt(4) - rand.nextInt(4));
            if (!worldIn.isEmptyBlock(blockpos)) continue;
            int j = 7 + rand.nextInt(5);
            for (int k = 0; k < j; ++k) {
                if (!AURA_SHOOT.get().canSurvive((LevelReader)worldIn, blockpos)) continue;
                worldIn.setBlock(blockpos.above(k), (BlockState)AURA_SHOOT.get().setValue((Property)AuraShootBlock.IS_TOP, (Comparable)Boolean.valueOf(k + 1 == j)), 2);
            }
        }
        return true;
    }
}

