/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.feature;

import com.mojang.serialization.Codec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.DiskConfiguration;

@ParametersAreNonnullByDefault
public class BogPatchFeature<T extends DiskConfiguration>
extends Feature<T> {
    public BogPatchFeature(Codec<T> configIn) {
        super(configIn);
    }

    public boolean place(FeaturePlaceContext<T> context) {
        return this.place(context.level(), context.random(), context.origin(), (DiskConfiguration)context.config());
    }

    public boolean place(WorldGenLevel world, RandomSource random, BlockPos pos, DiskConfiguration config) {
        int range = config.radius().sample(random) + 2;
        int y = pos.getY();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        boolean flag = false;
        for (BlockPos position : BlockPos.betweenClosed((BlockPos)pos.offset(-range, 0, -range), (BlockPos)pos.offset(range, 0, range))) {
            int i2;
            int l1 = position.getX() - pos.getX();
            if (l1 * l1 + (i2 = position.getZ() - pos.getZ()) * i2 > range * range) continue;
            flag |= this.place(config, world, random, y + config.halfHeight(), y - config.halfHeight() - 1, mutable.set((Vec3i)position));
        }
        return flag;
    }

    private boolean place(DiskConfiguration config, WorldGenLevel level, RandomSource random, int maxY, int minY, BlockPos.MutableBlockPos mutable) {
        boolean flag = false;
        for (int dy = maxY; dy > minY; --dy) {
            mutable.setY(dy);
            if (!config.target().test((Object)level, (Object)mutable) || random.nextInt(3) == 0) continue;
            BlockState state = config.stateProvider().getState(level, random, (BlockPos)mutable);
            level.setBlock((BlockPos)mutable, state, 2);
            this.markAboveForPostProcessing(level, (BlockPos)mutable);
            flag = true;
        }
        return flag;
    }
}

