/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.feature;

import androsa.gaiadimension.registry.registration.ModBlocks;
import androsa.gaiadimension.registry.registration.ModFluids;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.FlowingFluid;

public class MarshLakeFeature
extends Feature<NoneFeatureConfiguration> {
    public MarshLakeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        return this.place(context.level(), context.random(), context.origin());
    }

    public boolean place(WorldGenLevel level, RandomSource random, BlockPos origin) {
        int radius = 14;
        int rad = radius / 2 + 1;
        Direction dir = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        for (int x = -rad; x < rad; ++x) {
            for (int z = -rad; z < rad; ++z) {
                if (level.getBlockState(origin.offset(x, -1, z)).isFaceSturdy((BlockGetter)EmptyBlockGetter.INSTANCE, origin.offset(x, 0, z), Direction.DOWN) && level.isEmptyBlock(origin)) continue;
                return false;
            }
        }
        BlockPos pos = origin.below();
        switch (random.nextInt(3)) {
            case 1: {
                this.generateSquare(level, pos.offset(-(radius / 2), 0, -(radius / 2)), radius);
                break;
            }
            case 2: {
                this.generateTriangle(level, pos.offset(0, 0, -(radius / 2 + 1)), radius);
                break;
            }
            default: {
                this.generateCircle(level, pos, radius / 2);
            }
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                level.setBlock(pos.offset(x, 0, z), ((Block)ModBlocks.tough_golden_stone.get()).defaultBlockState(), 2);
                level.setBlock(pos.offset(x, 1, z), ((Block)ModBlocks.tough_golden_stone.get()).defaultBlockState(), 2);
            }
        }
        if (dir != Direction.NORTH) {
            level.setBlock(pos.offset(0, 2, -1), ((Block)ModBlocks.tough_golden_stone.get()).defaultBlockState(), 2);
        }
        if (dir != Direction.EAST) {
            level.setBlock(pos.offset(-1, 2, 0), ((Block)ModBlocks.tough_golden_stone.get()).defaultBlockState(), 2);
        }
        if (dir != Direction.SOUTH) {
            level.setBlock(pos.offset(0, 2, 1), ((Block)ModBlocks.tough_golden_stone.get()).defaultBlockState(), 2);
        }
        if (dir != Direction.WEST) {
            level.setBlock(pos.offset(1, 2, 0), ((Block)ModBlocks.tough_golden_stone.get()).defaultBlockState(), 2);
        }
        level.setBlock(pos.offset(0, 2, 0), ((FlowingFluid)ModFluids.mineral_water_still.get()).defaultFluidState().createLegacyBlock(), 2);
        level.scheduleTick(pos.offset(0, 2, 0), ((FlowingFluid)ModFluids.mineral_water_still.get()).defaultFluidState().getType(), 0);
        return true;
    }

    private void generateSquare(WorldGenLevel level, BlockPos origin, int radius) {
        for (int x = 0; x <= radius; ++x) {
            for (int z = 0; z <= radius; ++z) {
                this.genAir(level, origin.offset(x, 1, z));
                level.setBlock(origin.offset(x, 0, z), ((FlowingFluid)ModFluids.mineral_water_still.get()).defaultFluidState().createLegacyBlock(), 2);
            }
        }
    }

    private void generateCircle(WorldGenLevel level, BlockPos origin, int radius) {
        for (int i1 = origin.getX() - radius; i1 <= origin.getX() + radius; ++i1) {
            for (int j1 = origin.getZ() - radius; j1 <= origin.getZ() + radius; ++j1) {
                int l1;
                int k1 = i1 - origin.getX();
                if (k1 * k1 + (l1 = j1 - origin.getZ()) * l1 > radius * radius) continue;
                BlockPos blockpos1 = new BlockPos(i1, origin.getY(), j1);
                this.genAir(level, blockpos1.above());
                level.setBlock(blockpos1, ((FlowingFluid)ModFluids.mineral_water_still.get()).defaultFluidState().createLegacyBlock(), 2);
            }
        }
    }

    private void generateTriangle(WorldGenLevel level, BlockPos origin, int radius) {
        int inc = 1;
        int width = 0;
        for (int z = 0; z <= radius; ++z) {
            for (int x = -width; x <= width; ++x) {
                this.genAir(level, origin.offset(x, 1, z));
                level.setBlock(origin.offset(x, 0, z), ((FlowingFluid)ModFluids.mineral_water_still.get()).defaultFluidState().createLegacyBlock(), 2);
            }
            if (inc++ % 2 != 0) continue;
            ++width;
        }
    }

    private void genAir(WorldGenLevel level, BlockPos pos) {
        if (!level.getBlockState(pos).isAir()) {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
            this.markAboveForPostProcessing(level, pos);
        }
    }
}

