/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.feature;

import androsa.gaiadimension.registry.registration.ModBlocks;
import androsa.gaiadimension.world.gen.feature.config.FeatureHeightConfig;
import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

@ParametersAreNonnullByDefault
public class StaticSpikeFeature<T extends FeatureHeightConfig>
extends Feature<T> {
    private static final Supplier<BlockState> BLOCK = () -> ((Block)ModBlocks.charged_mineral.get()).defaultBlockState();

    public StaticSpikeFeature(Codec<T> configIn) {
        super(configIn);
    }

    public boolean place(FeaturePlaceContext<T> context) {
        return this.place(context.level(), context.random(), context.origin(), (FeatureHeightConfig)context.config());
    }

    public boolean place(WorldGenLevel worldIn, RandomSource rand, BlockPos position, T config) {
        int height = ((FeatureHeightConfig)config).startHeight + rand.nextInt(4);
        boolean flag = true;
        for (int cx = 0; cx < 3; ++cx) {
            for (int cz = 0; cz < 3; ++cz) {
                Block blockBelow;
                BlockPos pos1 = position.offset(cx - 1, 0, cz - 1);
                if (!worldIn.hasChunkAt(pos1) || (blockBelow = worldIn.getBlockState(pos1.below()).getBlock()) == ModBlocks.wasteland_stone.get() || blockBelow == ModBlocks.static_stone.get()) continue;
                flag = false;
            }
        }
        if (!flag) {
            return false;
        }
        for (int i = 0; i < height; ++i) {
            worldIn.setBlock(position.above(i), BLOCK.get(), 2);
            if (i >= height / 2) continue;
            worldIn.setBlock(position.offset(0, i, -1), BLOCK.get(), 2);
            worldIn.setBlock(position.offset(0, i, 1), BLOCK.get(), 2);
            worldIn.setBlock(position.offset(-1, i, 0), BLOCK.get(), 2);
            worldIn.setBlock(position.offset(1, i, 0), BLOCK.get(), 2);
            if (i >= height / 4) continue;
            worldIn.setBlock(position.offset(1, i, -1), BLOCK.get(), 2);
            worldIn.setBlock(position.offset(1, i, 1), BLOCK.get(), 2);
            worldIn.setBlock(position.offset(-1, i, -1), BLOCK.get(), 2);
            worldIn.setBlock(position.offset(-1, i, 1), BLOCK.get(), 2);
        }
        return true;
    }
}

