/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class TerrainSpikeFeature<T extends BlockStateConfiguration>
extends Feature<T> {
    public TerrainSpikeFeature(Codec<T> config) {
        super(config);
    }

    public boolean place(FeaturePlaceContext<T> context) {
        return this.place(context.level(), context.random(), context.origin(), ((BlockStateConfiguration)context.config()).state);
    }

    public boolean place(WorldGenLevel world, RandomSource random, BlockPos position, BlockState state) {
        for (int x = -2; x < 2; ++x) {
            for (int z = -2; z < 2; ++z) {
                if (!random.nextBoolean()) continue;
                BlockPos pos = position.offset(x, 0, z);
                boolean flag = true;
                for (int y = -2; y < 2 && flag; ++y) {
                    if (world.getBlockState((pos = pos.above(y)).below()) != state) continue;
                    for (int height = 1; height < random.nextInt(8) + 2; ++height) {
                        world.setBlock(pos.above(height), state, 2);
                    }
                    flag = false;
                }
            }
        }
        return true;
    }
}

