/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.structure.processor;

import androsa.gaiadimension.registry.registration.ModStructures;
import androsa.gaiadimension.world.gen.structure.processor.MiniTowerType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class BlockDegradeProcessor
extends StructureProcessor {
    public static final BlockDegradeProcessor AMETHYST_DECAY = new BlockDegradeProcessor(MiniTowerType.AMETHYST, 0.55f);
    public static final BlockDegradeProcessor COPAL_DECAY = new BlockDegradeProcessor(MiniTowerType.COPAL, 0.55f);
    public static final BlockDegradeProcessor JADE_DECAY = new BlockDegradeProcessor(MiniTowerType.JADE, 0.55f);
    public static final BlockDegradeProcessor JET_DECAY = new BlockDegradeProcessor(MiniTowerType.JET, 0.55f);
    public static final MapCodec<BlockDegradeProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MiniTowerType.CODEC.fieldOf("towertype").orElse((Object)MiniTowerType.AMETHYST).forGetter(obj -> obj.towertype), (App)Codec.FLOAT.fieldOf("integrity").orElse((Object)Float.valueOf(1.0f)).forGetter(obj -> Float.valueOf(obj.integrity))).apply((Applicative)instance, BlockDegradeProcessor::new));
    private final MiniTowerType towertype;
    private final float integrity;
    private static final Random random = new Random();

    public BlockDegradeProcessor(MiniTowerType type, float integrity) {
        this.towertype = type;
        this.integrity = integrity;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)ModStructures.BLOCK_DEGRADE.get();
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo process(LevelReader world, BlockPos pos, BlockPos tpos, StructureTemplate.StructureBlockInfo oldInfo, StructureTemplate.StructureBlockInfo newInfo, StructurePlaceSettings settings, @Nullable StructureTemplate template) {
        BlockState state = newInfo.state();
        if (state == this.towertype.getBrick()) {
            return random.nextFloat() > this.integrity ? newInfo : new StructureTemplate.StructureBlockInfo(newInfo.pos(), this.towertype.getBrickDecay(random), null);
        }
        if (state == this.towertype.getSlab()) {
            return random.nextFloat() > this.integrity ? newInfo : new StructureTemplate.StructureBlockInfo(newInfo.pos(), BlockDegradeProcessor.translateState(state, this.towertype.getSlabDecay(random).getBlock(), new Property[]{SlabBlock.TYPE, SlabBlock.WATERLOGGED}), null);
        }
        if (state == this.towertype.getStairs()) {
            return random.nextFloat() > this.integrity ? newInfo : new StructureTemplate.StructureBlockInfo(newInfo.pos(), BlockDegradeProcessor.translateState(state, this.towertype.getStairsDecay(random).getBlock(), new Property[]{StairBlock.FACING, StairBlock.HALF, StairBlock.SHAPE, StairBlock.WATERLOGGED}), null);
        }
        return newInfo;
    }

    protected static BlockState translateState(BlockState stateIn, Block blockOut, Property<?> ... properties) {
        BlockState stateOut = blockOut.defaultBlockState();
        for (Property<?> property : properties) {
            stateOut = BlockDegradeProcessor.copyValue(stateIn, stateOut, property);
        }
        return stateOut;
    }

    private static <T extends Comparable<T>> BlockState copyValue(BlockState from, BlockState to, Property<T> property) {
        return (BlockState)to.setValue(property, from.getValue(property));
    }
}

