/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.structure.processor;

import androsa.gaiadimension.registry.registration.ModBlocks;
import androsa.gaiadimension.registry.values.GaiaChestTables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;

public enum MiniTowerType implements StringRepresentable
{
    AMETHYST("AMETHYST", GaiaChestTables.CHESTS_MINITOWER_AMETHYST, (Supplier<Block>)ModBlocks.amethyst_bricks, (ImmutableList<Supplier<Block>>)ImmutableList.of(ModBlocks.cracked_amethyst_bricks, ModBlocks.crusted_amethyst_bricks), (Supplier<StairBlock>)ModBlocks.amethyst_brick_stairs, (ImmutableList<Supplier<StairBlock>>)ImmutableList.of(ModBlocks.cracked_amethyst_brick_stairs, ModBlocks.crusted_amethyst_brick_stairs), (Supplier<SlabBlock>)ModBlocks.amethyst_brick_slab, (ImmutableList<Supplier<SlabBlock>>)ImmutableList.of(ModBlocks.cracked_amethyst_brick_slab, ModBlocks.crusted_amethyst_brick_slab)),
    COPAL("COPAL", GaiaChestTables.CHESTS_MINITOWER_COPAL, (Supplier<Block>)ModBlocks.copal_bricks, (ImmutableList<Supplier<Block>>)ImmutableList.of(ModBlocks.cracked_copal_bricks, ModBlocks.crusted_copal_bricks), (Supplier<StairBlock>)ModBlocks.copal_brick_stairs, (ImmutableList<Supplier<StairBlock>>)ImmutableList.of(ModBlocks.cracked_copal_brick_stairs, ModBlocks.crusted_copal_brick_stairs), (Supplier<SlabBlock>)ModBlocks.copal_brick_slab, (ImmutableList<Supplier<SlabBlock>>)ImmutableList.of(ModBlocks.cracked_copal_brick_slab, ModBlocks.crusted_copal_brick_slab)),
    JADE("JADE", GaiaChestTables.CHESTS_MINITOWER_JADE, (Supplier<Block>)ModBlocks.jade_bricks, (ImmutableList<Supplier<Block>>)ImmutableList.of(ModBlocks.cracked_jade_bricks, ModBlocks.crusted_jade_bricks), (Supplier<StairBlock>)ModBlocks.jade_brick_stairs, (ImmutableList<Supplier<StairBlock>>)ImmutableList.of(ModBlocks.cracked_jade_brick_stairs, ModBlocks.crusted_jade_brick_stairs), (Supplier<SlabBlock>)ModBlocks.jade_brick_slab, (ImmutableList<Supplier<SlabBlock>>)ImmutableList.of(ModBlocks.cracked_jade_brick_slab, ModBlocks.crusted_jade_brick_slab)),
    JET("JET", GaiaChestTables.CHESTS_MINITOWER_JET, (Supplier<Block>)ModBlocks.jet_bricks, (ImmutableList<Supplier<Block>>)ImmutableList.of(ModBlocks.cracked_jet_bricks, ModBlocks.crusted_jet_bricks), (Supplier<StairBlock>)ModBlocks.jet_brick_stairs, (ImmutableList<Supplier<StairBlock>>)ImmutableList.of(ModBlocks.cracked_jet_brick_stairs, ModBlocks.crusted_jet_brick_stairs), (Supplier<SlabBlock>)ModBlocks.jet_brick_slab, (ImmutableList<Supplier<SlabBlock>>)ImmutableList.of(ModBlocks.cracked_jet_brick_slab, ModBlocks.crusted_jet_brick_slab));

    public static final Codec<MiniTowerType> CODEC;
    private final String name;
    private final ResourceKey<LootTable> chestLoot;
    private final Supplier<Block> brickBlock;
    private final ImmutableList<Supplier<Block>> brickDegrades;
    private final Supplier<StairBlock> stairsBlock;
    private final ImmutableList<Supplier<StairBlock>> stairsDegrades;
    private final Supplier<SlabBlock> slabBlock;
    private final ImmutableList<Supplier<SlabBlock>> slabDegrades;
    private static final Map<String, MiniTowerType> typeid;

    private MiniTowerType(String name, ResourceKey<LootTable> loot, Supplier<Block> brick, ImmutableList<Supplier<Block>> breakbricks, Supplier<StairBlock> stairs, ImmutableList<Supplier<StairBlock>> breakstairs, Supplier<SlabBlock> slab, ImmutableList<Supplier<SlabBlock>> breakslab) {
        this.name = name;
        this.chestLoot = loot;
        this.brickBlock = brick;
        this.brickDegrades = breakbricks;
        this.stairsBlock = stairs;
        this.stairsDegrades = breakstairs;
        this.slabBlock = slab;
        this.slabDegrades = breakslab;
    }

    public static MiniTowerType getType(String name) {
        return typeid.get(name);
    }

    public String getSerializedName() {
        return this.name;
    }

    public ResourceKey<LootTable> getChestLoot() {
        return this.chestLoot;
    }

    public BlockState getBrick() {
        return this.brickBlock.get().defaultBlockState();
    }

    public BlockState getBrickDecay(Random rand) {
        return ((Block)((Supplier)this.brickDegrades.get(rand.nextInt(this.brickDegrades.size()))).get()).defaultBlockState();
    }

    public BlockState getStairs() {
        return this.stairsBlock.get().defaultBlockState();
    }

    public BlockState getStairsDecay(Random rand) {
        return ((StairBlock)((Supplier)this.stairsDegrades.get(rand.nextInt(this.stairsDegrades.size()))).get()).defaultBlockState();
    }

    public BlockState getSlab() {
        return this.slabBlock.get().defaultBlockState();
    }

    public BlockState getSlabDecay(Random rand) {
        return ((SlabBlock)((Supplier)this.slabDegrades.get(rand.nextInt(this.slabDegrades.size()))).get()).defaultBlockState();
    }

    static {
        CODEC = StringRepresentable.fromEnum(MiniTowerType::values);
        typeid = (Map)Util.make((Object)Maps.newHashMap(), hashmap -> {
            for (MiniTowerType type : MiniTowerType.values()) {
                hashmap.put(type.name, type);
            }
        });
    }
}

