/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.layer.util;

import androsa.gaiadimension.world.layer.util.Area;
import androsa.gaiadimension.world.layer.util.PixelTransformer;
import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import net.minecraft.world.level.ChunkPos;

public class LazyArea
implements Area {
    private final PixelTransformer transformer;
    private final Long2IntLinkedOpenHashMap cache;
    private final int maxCache;

    public LazyArea(Long2IntLinkedOpenHashMap pCache, int pMaxCache, PixelTransformer pTransformer) {
        this.cache = pCache;
        this.maxCache = pMaxCache;
        this.transformer = pTransformer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int get(int pX, int pZ) {
        long i = ChunkPos.asLong((int)pX, (int)pZ);
        Long2IntLinkedOpenHashMap long2IntLinkedOpenHashMap = this.cache;
        synchronized (long2IntLinkedOpenHashMap) {
            int j = this.cache.get(i);
            if (j != Integer.MIN_VALUE) {
                return j;
            }
            int k = this.transformer.apply(pX, pZ);
            this.cache.put(i, k);
            if (this.cache.size() > this.maxCache) {
                for (int l = 0; l < this.maxCache / 16; ++l) {
                    this.cache.removeFirstInt();
                }
            }
            return k;
        }
    }

    public int getMaxCache() {
        return this.maxCache;
    }
}

