/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.hotkettles.client.render.blockentity;

import com.matthewperiut.hotkettles.blockentity.KettleBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class KettleBlockEntityRenderer
implements BlockEntityRenderer<KettleBlockEntity> {
    private static final ResourceLocation LIQUIDS_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"hotkettles", (String)"textures/blockentity/liquids.png");
    private static final float Z_FIGHT_OFFSET = 0.001f;

    public KettleBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(KettleBlockEntity kettle, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        matrices.pushPose();
        matrices.translate(0.0f, 1.0f, 0.0f);
        VertexConsumer vertexConsumer = vertexConsumers.getBuffer(RenderType.entityCutout((ResourceLocation)LIQUIDS_TEXTURE));
        KettleDraw drawer = new KettleDraw(matrices, vertexConsumer, light, overlay);
        float uv_x_offset = kettle.liquidHorizontalOffset;
        int uv_y_offset = kettle.liquidLevel;
        float TEXTURE_WIDTH = 2.0f;
        float TEXTURE_HEIGHT = 5.0f;
        if (kettle.dirX) {
            drawer.drawPoint(0.8135f, -0.8125f, 0.4375f, uv_x_offset / 64.0f, (TEXTURE_HEIGHT + (float)uv_y_offset) / 32.0f);
            drawer.drawPoint(0.8135f, -0.5f, 0.4375f, uv_x_offset / 64.0f, (float)uv_y_offset / 32.0f);
            drawer.drawPoint(0.8135f, -0.5f, 0.5625f, (TEXTURE_WIDTH + uv_x_offset) / 64.0f, (float)uv_y_offset / 32.0f);
            drawer.drawPoint(0.8135f, -0.8125f, 0.5625f, (TEXTURE_WIDTH + uv_x_offset) / 64.0f, (TEXTURE_HEIGHT + (float)uv_y_offset) / 32.0f);
            drawer.drawPoint(0.1865f, -0.8125f, 0.5625f, uv_x_offset / 64.0f, (TEXTURE_HEIGHT + (float)uv_y_offset) / 32.0f);
            drawer.drawPoint(0.1865f, -0.5f, 0.5625f, uv_x_offset / 64.0f, (float)uv_y_offset / 32.0f);
            drawer.drawPoint(0.1865f, -0.5f, 0.4375f, (TEXTURE_WIDTH + uv_x_offset) / 64.0f, (float)uv_y_offset / 32.0f);
            drawer.drawPoint(0.1865f, -0.8125f, 0.4375f, (TEXTURE_WIDTH + uv_x_offset) / 64.0f, (TEXTURE_HEIGHT + (float)uv_y_offset) / 32.0f);
        } else {
            drawer.drawPoint(0.4375f, -0.8125f, 0.1865f, uv_x_offset / 64.0f, (TEXTURE_HEIGHT + (float)uv_y_offset) / 32.0f);
            drawer.drawPoint(0.4375f, -0.5f, 0.1865f, uv_x_offset / 64.0f, (float)uv_y_offset / 32.0f);
            drawer.drawPoint(0.5625f, -0.5f, 0.1865f, (TEXTURE_WIDTH + uv_x_offset) / 64.0f, (float)uv_y_offset / 32.0f);
            drawer.drawPoint(0.5625f, -0.8125f, 0.1865f, (TEXTURE_WIDTH + uv_x_offset) / 64.0f, (TEXTURE_HEIGHT + (float)uv_y_offset) / 32.0f);
            drawer.drawPoint(0.5625f, -0.8125f, 0.8135f, uv_x_offset / 64.0f, (TEXTURE_HEIGHT + (float)uv_y_offset) / 32.0f);
            drawer.drawPoint(0.5625f, -0.5f, 0.8135f, uv_x_offset / 64.0f, (float)uv_y_offset / 32.0f);
            drawer.drawPoint(0.4375f, -0.5f, 0.8135f, (TEXTURE_WIDTH + uv_x_offset) / 64.0f, (float)uv_y_offset / 32.0f);
            drawer.drawPoint(0.4375f, -0.8125f, 0.8135f, (TEXTURE_WIDTH + uv_x_offset) / 64.0f, (TEXTURE_HEIGHT + (float)uv_y_offset) / 32.0f);
        }
        matrices.popPose();
    }

    private static class KettleDraw {
        PoseStack matrices;
        VertexConsumer vertexConsumer;
        int light;
        int overlay;
        PoseStack.Pose entry;
        Matrix4f positionMatrix;
        Matrix3f normalMatrix;

        KettleDraw(PoseStack matrices, VertexConsumer vertexConsumer, int light, int overlay) {
            this.entry = matrices.last();
            this.positionMatrix = this.entry.pose();
            this.normalMatrix = this.entry.normal();
            this.matrices = matrices;
            this.vertexConsumer = vertexConsumer;
            this.light = light;
            this.overlay = overlay;
        }

        public void drawPoint(float x, float y, float z, float u, float v) {
            this.vertexConsumer.addVertex(this.positionMatrix, x, y, z).setColor(255, 255, 255, 255).setUv(u, v).setOverlay(this.overlay).setLight(this.light).setNormal(this.entry, 0.0f, 0.0f, 1.0f);
        }
    }
}

