/*
 * Decompiled with CFR 0.152.
 */
package com.nine.ironladders.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.lwjgl.glfw.GLFW;

public class ClientHelper {
    public static boolean checkGoForward(Player player) {
        if (player instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)player;
            return localPlayer.input.forwardImpulse > 0.0f;
        }
        return false;
    }

    public static boolean shiftPressed() {
        Minecraft mc = Minecraft.getInstance();
        return GLFW.glfwGetKey((long)mc.getWindow().getWindow(), (int)340) == 1 || GLFW.glfwGetKey((long)mc.getWindow().getWindow(), (int)340) == 1;
    }

    public static Component componentWithColor(Component component, int color) {
        Style style = Style.EMPTY.withColor(color);
        return component.copy().withStyle(style);
    }

    public static void spawnMorphParticles(BlockPos blockPos, BlockState state, Level level) {
        if (level.isClientSide) {
            VoxelShape shape = state.getShape((BlockGetter)level, blockPos);
            RandomSource random = level.random;
            shape.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                for (int i = 0; i < 7; ++i) {
                    double x = (double)blockPos.getX() + random.nextDouble() * (maxX - minX) + minX;
                    double y = (double)blockPos.getY() + random.nextDouble() * (maxY - minY) + minY;
                    double z = (double)blockPos.getZ() + random.nextDouble() * (maxZ - minZ) + minZ;
                    level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), x, y, z, 0.0, 0.0, 0.0);
                }
            });
        }
    }

    public static void spawnUpgradeParticles(BlockPos blockPos, BlockState state, Level level) {
        if (level.isClientSide) {
            VoxelShape shape = state.getShape((BlockGetter)level, blockPos);
            RandomSource random = level.random;
            shape.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                for (int i = 0; i < 7; ++i) {
                    double x = (double)blockPos.getX() + random.nextDouble() * (maxX - minX) + minX;
                    double y = (double)blockPos.getY() + random.nextDouble() * (maxY - minY) + minY;
                    double z = (double)blockPos.getZ() + random.nextDouble() * (maxZ - minZ) + minZ;
                    level.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, x, y, z, 0.0, 0.0, 0.0);
                }
            });
        }
    }
}

