/*
 * Decompiled with CFR 0.152.
 */
package com.nine.ironladders.common.block;

import com.nine.ironladders.ILConfig;
import com.nine.ironladders.common.block.CryingObsidianLadder;
import com.nine.ironladders.common.block.entity.MetalLadderEntity;
import com.nine.ironladders.common.utils.LadderPositions;
import com.nine.ironladders.common.utils.LadderProperties;
import com.nine.ironladders.common.utils.LadderType;
import com.nine.ironladders.init.BlockRegistry;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class BaseMetalLadder
extends LadderBlock
implements EntityBlock {
    private final LadderType type;

    public BaseMetalLadder(BlockBehaviour.Properties properties, LadderType type) {
        super(properties.forceSolidOff().noOcclusion());
        this.type = type;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(LadderProperties.STATE_IN_CHAIN, (Comparable)((Object)LadderPositions.SINGLE))).setValue((Property)LadderProperties.HIDDEN, (Comparable)Boolean.valueOf(false))).setValue((Property)LadderProperties.LIGHTED, (Comparable)Boolean.valueOf(false))).setValue((Property)LadderProperties.HAS_SIGNAL, (Comparable)Boolean.valueOf(false))).setValue((Property)LadderProperties.POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean supportsExternalFaceHiding(BlockState state) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean skipRendering(BlockState pState, BlockState pAdjacentBlockState, Direction pDirection) {
        return pDirection == Direction.UP && pAdjacentBlockState.getBlock() instanceof LadderBlock;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MetalLadderEntity) {
            MetalLadderEntity metalLadderEntity = (MetalLadderEntity)blockEntity;
            BlockState morphState = metalLadderEntity.getMorphState();
            if (metalLadderEntity.getMorphState() != null && (!(metalLadderEntity.getMorphState().getBlock() instanceof BaseMetalLadder) || metalLadderEntity.getMorphState().getBlock() instanceof CryingObsidianLadder)) {
                morphState.getBlock().animateTick(state, level, pos, random);
            }
        }
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MetalLadderEntity) {
            MetalLadderEntity ladderEntity = (MetalLadderEntity)blockEntity;
            return ladderEntity.getMorphState() != null ? ladderEntity.getMorphState().getSoundType() : this.soundType;
        }
        return this.soundType;
    }

    public void neighborChanged(BlockState blockState, Level level, BlockPos pos, Block block, @javax.annotation.Nullable Orientation orientation, boolean b) {
        if (!level.isClientSide && ((Boolean)blockState.getValue((Property)LadderProperties.POWERED)).booleanValue()) {
            this.updatePositionRelations(blockState, level, pos);
            boolean flag = (Boolean)blockState.getValue((Property)LadderProperties.HAS_SIGNAL);
            boolean flag2 = level.hasNeighborSignal(pos);
            boolean flag3 = this.hasActiveInARow(level, pos);
            if (flag != (flag2 || flag3)) {
                if (flag) {
                    level.scheduleTick(pos, (Block)this, 1);
                    this.updateChain(level, pos);
                } else {
                    level.setBlock(pos, (BlockState)blockState.cycle((Property)LadderProperties.HAS_SIGNAL), 3);
                    this.updateChain(level, pos);
                }
            }
        }
    }

    private void updatePositionRelations(BlockState state, Level level, BlockPos pos) {
        if (!((Boolean)state.getValue((Property)LadderProperties.POWERED)).booleanValue()) {
            return;
        }
        boolean hasPoweredAbove = false;
        boolean hasPoweredBelow = false;
        Direction startDirection = (Direction)state.getValue(LadderProperties.FACING);
        if (level.getBlockState(pos.above()).getBlock() instanceof BaseMetalLadder && level.getBlockState(pos.above()).getValue((Property)FACING) == startDirection) {
            hasPoweredAbove = (Boolean)level.getBlockState(pos.above()).getValue((Property)LadderProperties.POWERED);
        }
        if (level.getBlockState(pos.below()).getBlock() instanceof BaseMetalLadder && level.getBlockState(pos.below()).getValue((Property)FACING) == startDirection) {
            hasPoweredBelow = (Boolean)level.getBlockState(pos.below()).getValue((Property)LadderProperties.POWERED);
        }
        if (hasPoweredAbove && hasPoweredBelow) {
            level.setBlock(pos, (BlockState)state.setValue(LadderProperties.STATE_IN_CHAIN, (Comparable)((Object)LadderPositions.HAS_DOWN_AND_UP_NEIGHBOUR)), 3);
            return;
        }
        if (hasPoweredAbove) {
            level.setBlock(pos, (BlockState)state.setValue(LadderProperties.STATE_IN_CHAIN, (Comparable)((Object)LadderPositions.HAS_UP_NEIGHBOUR)), 3);
            return;
        }
        if (hasPoweredBelow) {
            level.setBlock(pos, (BlockState)state.setValue(LadderProperties.STATE_IN_CHAIN, (Comparable)((Object)LadderPositions.HAS_DOWN_NEIGHBOUR)), 3);
            return;
        }
        level.setBlock(pos, (BlockState)state.setValue(LadderProperties.STATE_IN_CHAIN, (Comparable)((Object)LadderPositions.SINGLE)), 3);
    }

    public void updateChain(Level level, BlockPos pos) {
        boolean canGoUp = true;
        boolean canGoDown = true;
        Direction startFacingDirection = (Direction)level.getBlockState(pos).getValue(LadderProperties.FACING);
        for (int height = 1; height < 256; ++height) {
            BlockPos posAbove = pos.above(height);
            BlockPos posBelow = pos.below(height);
            Block blockAbove = level.getBlockState(posAbove).getBlock();
            Block blockBelow = level.getBlockState(posBelow).getBlock();
            BlockState stateAbove = level.getBlockState(posAbove);
            BlockState stateBelow = level.getBlockState(posBelow);
            if (canGoUp) {
                Direction currentUpFacingDirection;
                canGoUp = blockAbove instanceof BaseMetalLadder ? startFacingDirection == (currentUpFacingDirection = (Direction)stateAbove.getValue(LadderProperties.FACING)) && (Boolean)stateAbove.getValue((Property)LadderProperties.POWERED) != false : false;
            }
            if (canGoDown) {
                Direction currentDownFacingDirection;
                canGoDown = blockBelow instanceof BaseMetalLadder ? startFacingDirection == (currentDownFacingDirection = (Direction)stateBelow.getValue(LadderProperties.FACING)) && (Boolean)stateBelow.getValue((Property)LadderProperties.POWERED) != false : false;
            }
            if (!canGoDown && !canGoUp) break;
            if (canGoUp && (this.hasActiveInARow(level, posAbove) || level.hasNeighborSignal(posAbove)) != (Boolean)stateAbove.getValue((Property)LadderProperties.HAS_SIGNAL)) {
                level.setBlock(posAbove, (BlockState)stateAbove.cycle((Property)LadderProperties.HAS_SIGNAL), 3);
            }
            if (!canGoDown || (this.hasActiveInARow(level, posBelow) || level.hasNeighborSignal(posBelow)) == (Boolean)stateBelow.getValue((Property)LadderProperties.HAS_SIGNAL)) continue;
            level.setBlock(posBelow, (BlockState)stateBelow.cycle((Property)LadderProperties.HAS_SIGNAL), 3);
        }
    }

    private boolean hasActiveInARow(Level level, BlockPos pos) {
        boolean canGoDown = true;
        boolean canGoUp = true;
        Direction startFacingDirection = (Direction)level.getBlockState(pos).getValue((Property)FACING);
        for (int height = 1; height < level.getHeight(); ++height) {
            Block blockBelow = level.getBlockState(pos.below(height)).getBlock();
            Block blockAbove = level.getBlockState(pos.above(height)).getBlock();
            BlockState stateAbove = level.getBlockState(pos.above(height));
            BlockState stateBelow = level.getBlockState(pos.below(height));
            if (canGoUp) {
                Direction currentUpFacingDirection;
                canGoUp = blockAbove instanceof BaseMetalLadder ? startFacingDirection == (currentUpFacingDirection = (Direction)stateAbove.getValue((Property)FACING)) && (Boolean)stateAbove.getValue((Property)LadderProperties.POWERED) != false : false;
            }
            if (canGoDown) {
                Direction currentDownFacingDirection;
                canGoDown = blockBelow instanceof BaseMetalLadder ? startFacingDirection == (currentDownFacingDirection = (Direction)stateBelow.getValue((Property)FACING)) && (Boolean)stateBelow.getValue((Property)LadderProperties.POWERED) != false : false;
            }
            if (canGoUp || canGoDown) {
                if (canGoUp && level.hasNeighborSignal(pos.above(height))) {
                    return true;
                }
                if (!canGoDown || !level.hasNeighborSignal(pos.below(height))) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource p_221940_) {
        if (((Boolean)state.getValue((Property)LadderProperties.POWERED)).booleanValue() && ((Boolean)state.getValue((Property)LadderProperties.HAS_SIGNAL)).booleanValue() && !level.hasNeighborSignal(pos) && !this.hasActiveInARow((Level)level, pos)) {
            level.setBlock(pos, (BlockState)state.cycle((Property)LadderProperties.HAS_SIGNAL), 3);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LadderProperties.POWERED});
        builder.add(new Property[]{LadderProperties.LIGHTED});
        builder.add(new Property[]{LadderProperties.HIDDEN});
        builder.add(new Property[]{LadderProperties.STATE_IN_CHAIN});
        builder.add(new Property[]{LadderProperties.HAS_SIGNAL});
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        MetalLadderEntity ladderEntity;
        int lightLevel = this == BlockRegistry.CRYING_OBSIDIAN_LADDER.get() ? 10 : 0;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MetalLadderEntity && (ladderEntity = (MetalLadderEntity)blockEntity).getMorphState() != null) {
            BlockState morphState = ladderEntity.getMorphState();
            if (morphState.getBlock() instanceof CryingObsidianLadder) {
                lightLevel = 10;
            } else if (!(morphState.getBlock() instanceof BaseMetalLadder)) {
                lightLevel = morphState.getLightEmission(level, pos);
            }
        }
        if (((Boolean)state.getValue((Property)LadderProperties.LIGHTED)).booleanValue()) {
            lightLevel = Math.max(lightLevel, 13);
        }
        return lightLevel;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState stateBefore, boolean bool) {
        if (!stateBefore.is(state.getBlock())) {
            level.updateNeighborsAt(pos, (Block)this);
        }
    }

    public LadderType getType() {
        return this.type;
    }

    public int getSpeedMultiplier() {
        boolean nonVanillaAllowed = (Boolean)ILConfig.nonVanillaLadders.get();
        return switch (this.type) {
            case LadderType.COPPER -> (Integer)ILConfig.copperLadderSpeedMultiplier.get();
            case LadderType.IRON -> (Integer)ILConfig.ironLadderSpeedMultiplier.get();
            case LadderType.GOLD -> (Integer)ILConfig.goldLadderSpeedMultiplier.get();
            case LadderType.DIAMOND -> (Integer)ILConfig.diamondLadderSpeedMultiplier.get();
            case LadderType.OBSIDIAN, LadderType.CRYING_OBSIDIAN, LadderType.BEDROCK -> (Integer)ILConfig.obsidianLadderSpeedMultiplier.get();
            case LadderType.NETHERITE -> (Integer)ILConfig.netheriteLadderSpeedMultiplier.get();
            case LadderType.TIN -> {
                if (nonVanillaAllowed) {
                    yield (Integer)ILConfig.tinLadderSpeedMultiplier.get();
                }
                yield 1;
            }
            case LadderType.BRONZE -> {
                if (nonVanillaAllowed) {
                    yield (Integer)ILConfig.bronzeLadderSpeedMultiplier.get();
                }
                yield 1;
            }
            case LadderType.LEAD -> {
                if (nonVanillaAllowed) {
                    yield (Integer)ILConfig.leadLadderSpeedMultiplier.get();
                }
                yield 1;
            }
            case LadderType.STEEL -> {
                if (nonVanillaAllowed) {
                    yield (Integer)ILConfig.steelLadderSpeedMultiplier.get();
                }
                yield 1;
            }
            case LadderType.ALUMINUM -> {
                if (nonVanillaAllowed) {
                    yield (Integer)ILConfig.aluminumLadderSpeedMultiplier.get();
                }
                yield 1;
            }
            case LadderType.SILVER -> {
                if (nonVanillaAllowed) {
                    yield (Integer)ILConfig.silverLadderSpeedMultiplier.get();
                }
                yield 1;
            }
            default -> 1;
        };
    }

    public boolean isPowered(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)LadderProperties.POWERED);
    }

    public boolean isPoweredAndHasSignal(BlockState blockState) {
        if (blockState.getBlock() instanceof BaseMetalLadder) {
            return this.isPowered(blockState) && (Boolean)blockState.getValue((Property)LadderProperties.HAS_SIGNAL) != false;
        }
        return false;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new MetalLadderEntity(pos, state);
    }

    public boolean canBeReplaced(@Nonnull BlockState state, @Nonnull BlockPlaceContext useContext) {
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag tooltipFlag) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        if (Screen.hasShiftDown()) {
            list.add((Component)Component.translatable((String)"ironladders.tooltip.speed_bonus", (Object[])new Object[]{this.getSpeedMultiplier()}).withStyle(ChatFormatting.GRAY));
        }
    }
}

