/*
 * Decompiled with CFR 0.152.
 */
package com.nine.ironladders.common.block;

import com.nine.ironladders.ILConfig;
import com.nine.ironladders.common.block.BaseMetalLadder;
import com.nine.ironladders.common.utils.LadderType;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class CopperLadderBlock
extends BaseMetalLadder
implements WeatheringCopper {
    private final WeatheringCopper.WeatherState weatherState;

    public CopperLadderBlock(BlockBehaviour.Properties properties, LadderType type, WeatheringCopper.WeatherState state) {
        super(properties, type);
        this.weatherState = state;
    }

    @Override
    public int getSpeedMultiplier() {
        return (Integer)ILConfig.copperLadderSpeedMultiplier.get();
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        this.changeOverTime(state, level, pos, randomSource);
    }

    private void awardPlayer(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ResourceLocation advancementId = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"husbandry/wax_off");
            AdvancementHolder advancement = serverPlayer.server.getAdvancements().get(advancementId);
            if (advancement != null) {
                serverPlayer.getAdvancements().award(advancement, "wax_off");
            }
        }
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public float getChanceModifier() {
        return this.getAge() == WeatheringCopper.WeatherState.UNAFFECTED ? 0.75f : 1.0f;
    }

    public WeatheringCopper.WeatherState getAge() {
        return this.weatherState;
    }
}

