/*
 * Decompiled with CFR 0.152.
 */
package com.nine.ironladders.common.block.entity;

import com.nine.ironladders.client.render.MetalLadderBakedModel;
import com.nine.ironladders.init.BlockEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class MetalLadderEntity
extends BlockEntity {
    private BlockState morphState;

    public MetalLadderEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.METAL_LADDER.get(), pos, state);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        BlockState state;
        super.loadAdditional(tag, provider);
        if (tag.contains("morph_type") && !(state = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK, (CompoundTag)tag.getCompound("morph_type"))).isAir()) {
            this.morphState = state;
            return;
        }
        this.morphState = null;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.morphState != null) {
            tag.put("morph_type", (Tag)NbtUtils.writeBlockState((BlockState)this.morphState));
        }
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithId(pRegistries);
    }

    @NotNull
    public ModelData getModelData() {
        return ModelData.builder().with(MetalLadderBakedModel.MORPH_MODEL_PROPERTY, (Object)this.morphState).build();
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
        this.setChanged();
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider lookupProvider) {
        this.handleUpdateTag(packet.getTag(), lookupProvider);
    }

    public void setMorphState(BlockState state) {
        this.morphState = state;
        this.setChanged();
    }

    public void setChanged() {
        super.setChanged();
        if (this.level == null) {
            return;
        }
        this.requestModelDataUpdate();
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        this.level.getLightEngine().checkBlock(this.getBlockPos());
        this.level.updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
        this.getBlockState().updateNeighbourShapes((LevelAccessor)this.level, this.worldPosition, 2);
    }

    public BlockState getMorphState() {
        return this.morphState;
    }
}

