/*
 * Decompiled with CFR 0.152.
 */
package com.nine.ironladders.common.item;

import com.nine.ironladders.ILConfig;
import com.nine.ironladders.common.block.BaseMetalLadder;
import com.nine.ironladders.common.block.entity.MetalLadderEntity;
import com.nine.ironladders.common.utils.BlockStateUtils;
import com.nine.ironladders.common.utils.LadderType;
import com.nine.ironladders.common.utils.UpgradeType;
import com.nine.ironladders.init.ItemRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class CustomUpgradeItem
extends Item {
    UpgradeType type;

    public CustomUpgradeItem(Item.Properties props, UpgradeType type) {
        super(props);
        this.type = type;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (stack.getItem() == ItemRegistry.POWER_UPGRADE_ITEM.get() && !((Boolean)ILConfig.enablePoweredLaddersUpgrade.get()).booleanValue()) {
            return InteractionResult.FAIL;
        }
        if (stack.getItem() == ItemRegistry.LIGHT_UPGRADE_ITEM.get() && !((Boolean)ILConfig.enableGlowingLaddersUpgrade.get()).booleanValue()) {
            return InteractionResult.FAIL;
        }
        BlockPos blockPos = context.getClickedPos();
        Level level = context.getLevel();
        BlockState blockState = level.getBlockState(blockPos);
        Block block = blockState.getBlock();
        BooleanProperty property = this.type.getProperty();
        if (block instanceof BaseMetalLadder && property != null) {
            if (!player.isShiftKeyDown()) {
                this.upgradeSingleBlock(blockState, level, blockPos);
            } else {
                this.upgradeSingleBlock(blockState, level, blockPos);
                this.upgradeMultipleLadders(level, blockPos, blockState);
            }
        }
        return InteractionResult.FAIL;
    }

    private void upgradeSingleBlock(BlockState blockState, Level level, BlockPos blockPos) {
        BooleanProperty property;
        BlockState upgradeState = (BlockState)blockState.setValue((Property)property, (Comparable)Boolean.valueOf((Boolean)blockState.getValue((Property)(property = this.type.getProperty())) == false));
        MetalLadderEntity metalLadderEntity = new MetalLadderEntity(blockPos, upgradeState);
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof MetalLadderEntity) {
            MetalLadderEntity metalLadderEntity2 = (MetalLadderEntity)blockEntity;
            metalLadderEntity.setMorphState(metalLadderEntity2.getMorphState());
            level.removeBlockEntity(blockPos);
            blockEntity.setRemoved();
            level.playSound(null, blockPos, SoundEvents.LADDER_PLACE, SoundSource.BLOCKS, 1.0f, 0.9f + level.random.nextFloat() * 0.2f);
            level.setBlock(blockPos, upgradeState, 3);
            level.setBlockEntity((BlockEntity)metalLadderEntity);
            level.updateNeighborsAt(blockPos.above(), level.getBlockState(blockPos).getBlock());
        }
    }

    public void upgradeMultipleLadders(Level level, BlockPos blockPos, BlockState state) {
        LadderType startType;
        boolean canGoUp = true;
        boolean canGoDown = true;
        Block startBlock = state.getBlock();
        LadderType upperType = startType = LadderType.DEFAULT;
        LadderType bottomType = startType;
        Direction startFacingDirection = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        boolean startPropertyValue = (Boolean)state.getValue((Property)this.type.getProperty());
        for (int height = 1; height < level.getMaxY(); ++height) {
            BaseMetalLadder metalLadder;
            if (startBlock instanceof BaseMetalLadder) {
                BaseMetalLadder metalLadder2 = (BaseMetalLadder)startBlock;
                startType = metalLadder2.getType();
            }
            BlockState stateAbove = level.getBlockState(blockPos.above(height));
            BlockPos abovePos = blockPos.above(height);
            Block blockAbove = stateAbove.getBlock();
            BlockPos belowPos = blockPos.below(height);
            BlockState stateBelow = level.getBlockState(blockPos.below(height));
            Block blockBelow = stateBelow.getBlock();
            if (blockAbove instanceof BaseMetalLadder) {
                metalLadder = (BaseMetalLadder)blockAbove;
                upperType = metalLadder.getType();
            }
            if (blockBelow instanceof BaseMetalLadder) {
                metalLadder = (BaseMetalLadder)blockBelow;
                bottomType = metalLadder.getType();
            }
            if (canGoUp) {
                Direction currentUpFacingDirection;
                canGoUp = blockAbove instanceof BaseMetalLadder && blockAbove == startBlock && startPropertyValue == (Boolean)stateAbove.getValue((Property)this.type.getProperty()) ? startFacingDirection == (currentUpFacingDirection = (Direction)stateAbove.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) : false;
            }
            if (canGoDown) {
                Direction currentDownFacingDirection;
                canGoDown = blockBelow instanceof BaseMetalLadder && blockBelow == startBlock && startPropertyValue == (Boolean)stateBelow.getValue((Property)this.type.getProperty()) ? startFacingDirection == (currentDownFacingDirection = (Direction)stateBelow.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) : false;
            }
            if (!canGoUp && !canGoDown) break;
            if (canGoUp && upperType == startType) {
                state = BlockStateUtils.getStateWithSyncedPropsNoP(blockAbove.defaultBlockState(), stateAbove);
                this.upgradeSingleBlock(state, level, abovePos);
            }
            if (!canGoDown || bottomType != startType) continue;
            state = BlockStateUtils.getStateWithSyncedPropsNoP(blockBelow.defaultBlockState(), stateBelow);
            this.upgradeSingleBlock(state, level, belowPos);
        }
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (ItemRegistry.checkDisabled(stack.getItem())) {
            tooltip.add((Component)Component.translatable((String)"ironladders.tooltip.disabled").withStyle(ChatFormatting.RED));
            return;
        }
        boolean shiftDown = Screen.hasShiftDown();
        Style style = Style.EMPTY.withColor(shiftDown ? 0xCBCBCB : 0x808080);
        tooltip.add((Component)Component.translatable((String)"ironladders.tooltip.hold_for", (Object[])new Object[]{Component.translatable((String)"ironladders.tooltip.shift").withStyle(style)}).withStyle(ChatFormatting.GRAY));
        if (shiftDown) {
            Object key = this.getDescriptionId().split("\\.")[2];
            int i = 0;
            key = "ironladders.tooltip." + (String)key + ".info_";
            while (Language.getInstance().has((String)key + i)) {
                tooltip.add((Component)Component.translatable((String)((String)key + i)).withStyle(ChatFormatting.GRAY));
                ++i;
            }
        }
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

