/*
 * Decompiled with CFR 0.152.
 */
package com.nine.ironladders.common.item;

import com.nine.ironladders.ILConfig;
import com.nine.ironladders.client.ClientHelper;
import com.nine.ironladders.common.block.BaseMetalLadder;
import com.nine.ironladders.common.block.entity.MetalLadderEntity;
import com.nine.ironladders.common.component.CustomComponents;
import com.nine.ironladders.common.utils.LadderProperties;
import com.nine.ironladders.common.utils.LadderType;
import com.nine.ironladders.network.MorphPacket;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.PacketDistributor;
import org.lwjgl.glfw.GLFW;

public class MorphUpgradeItem
extends Item {
    public MorphUpgradeItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null || Objects.equals(MorphUpgradeItem.getMorphType(stack), "") && !player.isShiftKeyDown() || !((Boolean)ILConfig.enableMorphLaddersUpgrade.get()).booleanValue()) {
            return InteractionResult.FAIL;
        }
        BlockPos blockPos = context.getClickedPos();
        Level level = context.getLevel();
        BlockState blockState = level.getBlockState(blockPos);
        Block block = blockState.getBlock();
        if (block instanceof LadderBlock) {
            if (player.isShiftKeyDown()) {
                level.playSound(null, blockPos, SoundEvents.SLIME_SQUISH, SoundSource.PLAYERS, 1.0f, 1.0f);
                MorphUpgradeItem.setMorphType(stack, level, blockPos, blockState);
            } else if (block instanceof BaseMetalLadder && this.morphSingleBlock(level, blockPos, stack)) {
                level.playSound(null, blockPos, SoundEvents.LADDER_PLACE, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        return InteractionResult.FAIL;
    }

    private static void setMorphType(ItemStack stack, Level level, BlockPos pos, BlockState state) {
        MetalLadderEntity ladderEntity;
        String valueToSet = Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)state.getBlock())).toString();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MetalLadderEntity && (ladderEntity = (MetalLadderEntity)blockEntity).getMorphState() != null) {
            if (level.isClientSide) {
                boolean ctrlPressed;
                Minecraft mc = Minecraft.getInstance();
                boolean bl = ctrlPressed = GLFW.glfwGetKey((long)mc.getWindow().getWindow(), (int)342) == 1 || GLFW.glfwGetKey((long)mc.getWindow().getWindow(), (int)346) == 1;
                if (ctrlPressed) {
                    valueToSet = Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)ladderEntity.getMorphState().getBlock())).toString();
                }
                PacketDistributor.sendToServer((CustomPacketPayload)new MorphPacket(valueToSet), (CustomPacketPayload[])new CustomPacketPayload[0]);
                MorphUpgradeItem.writeMorphType(stack, valueToSet);
            }
        } else {
            MorphUpgradeItem.writeMorphType(stack, valueToSet);
        }
    }

    public boolean morphSingleBlock(Level level, BlockPos blockPos, ItemStack stack) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof MetalLadderEntity) {
            MetalLadderEntity metalLadderEntity = (MetalLadderEntity)blockEntity;
            Optional block1Holder = BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)MorphUpgradeItem.getMorphType(stack)));
            Block block2 = level.getBlockState(blockPos).getBlock();
            if (block1Holder.isPresent()) {
                Block block1 = (Block)((Holder.Reference)block1Holder.get()).value();
                if (block1 == block2) {
                    if (metalLadderEntity.getMorphState() != null) {
                        metalLadderEntity.setMorphState(null);
                        ClientHelper.spawnMorphParticles(blockPos, block2.defaultBlockState(), level);
                    }
                    return false;
                }
                BlockState state = block1.withPropertiesOf(level.getBlockState(blockPos));
                metalLadderEntity.setMorphState((BlockState)(metalLadderEntity.getMorphState() != null && metalLadderEntity.getMorphState().is(state.getBlock()) ? null : state));
                ClientHelper.spawnMorphParticles(blockPos, metalLadderEntity.getMorphState() != null && metalLadderEntity.getMorphState().is(state.getBlock()) ? state : level.getBlockState(blockPos), level);
                return true;
            }
        }
        return false;
    }

    public void morphMultipleLadders(Player player, ItemStack stack, Level level, BlockPos pos) {
        BlockState state;
        Block block;
        if (!player.getCooldowns().isOnCooldown(stack) && player.isShiftKeyDown() && (block = (state = level.getBlockState(pos)).getBlock()) instanceof BaseMetalLadder) {
            BaseMetalLadder baseMetalLadder = (BaseMetalLadder)block;
            MetalLadderEntity entity = (MetalLadderEntity)level.getBlockEntity(pos);
            if (entity != null) {
                player.getCooldowns().addCooldown(stack, 10);
                if (this.morphSingleBlock(level, pos, stack)) {
                    level.playSound(null, pos, SoundEvents.LADDER_PLACE, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                this.morphBlocks(entity, level, pos, state, stack);
                baseMetalLadder.updateChain(level, pos);
            }
        }
    }

    public void morphBlocks(MetalLadderEntity entity, Level level, BlockPos blockPos, BlockState state, ItemStack stack) {
        Block morphBlock;
        LadderType startType;
        boolean canGoUp = true;
        boolean canGoDown = true;
        Block startBlock = state.getBlock();
        LadderType upperType = startType = LadderType.DEFAULT;
        LadderType bottomType = startType;
        Direction startFacingDirection = (Direction)state.getValue(LadderProperties.FACING);
        Block block = morphBlock = entity.getMorphState() == null ? null : entity.getMorphState().getBlock();
        for (int height = 1; height < level.getMaxY(); ++height) {
            BaseMetalLadder metalLadder;
            if (startBlock instanceof BaseMetalLadder) {
                BaseMetalLadder metalLadder2 = (BaseMetalLadder)startBlock;
                startType = metalLadder2.getType();
            }
            BlockState stateAbove = level.getBlockState(blockPos.above(height));
            BlockPos abovePos = blockPos.above(height);
            Block blockAbove = stateAbove.getBlock();
            BlockPos belowPos = blockPos.below(height);
            BlockState stateBelow = level.getBlockState(blockPos.below(height));
            Block blockBelow = stateBelow.getBlock();
            if (blockAbove instanceof BaseMetalLadder) {
                metalLadder = (BaseMetalLadder)blockAbove;
                upperType = metalLadder.getType();
            }
            if (blockBelow instanceof BaseMetalLadder) {
                metalLadder = (BaseMetalLadder)blockBelow;
                bottomType = metalLadder.getType();
            }
            if (canGoUp) {
                Direction currentUpFacingDirection;
                canGoUp = blockAbove instanceof BaseMetalLadder ? startFacingDirection == (currentUpFacingDirection = (Direction)stateAbove.getValue(LadderProperties.FACING)) && morphBlock != stateAbove.getBlock() : false;
            }
            if (canGoDown) {
                Direction currentDownFacingDirection;
                canGoDown = blockBelow instanceof BaseMetalLadder ? startFacingDirection == (currentDownFacingDirection = (Direction)stateBelow.getValue(LadderProperties.FACING)) && morphBlock != stateBelow.getBlock() : false;
            }
            if (!canGoUp && !canGoDown) break;
            if (canGoUp && upperType == startType) {
                this.morphSingleBlock(level, abovePos, stack);
            }
            if (!canGoDown || bottomType != startType) continue;
            this.morphSingleBlock(level, belowPos, stack);
        }
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public static void writeMorphType(ItemStack stack, String type) {
        stack.set((DataComponentType)CustomComponents.MORPH_TYPE.get(), (Object)type);
    }

    public static String getMorphType(ItemStack stack) {
        if (stack.get((DataComponentType)CustomComponents.MORPH_TYPE.get()) != null) {
            return (String)stack.get((DataComponentType)CustomComponents.MORPH_TYPE.get());
        }
        return "";
    }

    public static Component getMorphTypeMod(ItemStack stack) {
        String namespace = MorphUpgradeItem.getMorphType(stack).split(":")[0];
        return Component.literal((String)ModList.get().getModContainerById(namespace).map(modContainer -> modContainer.getModInfo().getDisplayName()).orElse(namespace));
    }

    public static Component getMorphContent(ItemStack stack) {
        return Component.literal((String)Component.translatable((String)("block." + MorphUpgradeItem.getMorphType(stack).replace(':', '.'))).getString());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (!((Boolean)ILConfig.enableMorphLaddersUpgrade.get()).booleanValue()) {
            tooltip.add((Component)Component.translatable((String)"ironladders.tooltip.disabled").withStyle(ChatFormatting.RED));
            return;
        }
        boolean shiftDown = Screen.hasShiftDown();
        Component modName = ClientHelper.componentWithColor((Component)MorphUpgradeItem.getMorphTypeMod(stack).copy().withStyle(ChatFormatting.GRAY), 0xCBCBCB);
        Component morphContent = MorphUpgradeItem.getMorphContent(stack);
        if (!Objects.equals(MorphUpgradeItem.getMorphType(stack), "")) {
            if (shiftDown) {
                tooltip.add((Component)Component.translatable((String)"ironladders.tooltip.morph_upgrade.type_1", (Object[])new Object[]{modName, morphContent}).withStyle(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)Component.translatable((String)"ironladders.tooltip.morph_upgrade.type_0", (Object[])new Object[]{morphContent}).withStyle(ChatFormatting.GRAY));
            }
        }
        Component component1 = ClientHelper.componentWithColor((Component)Component.translatable((String)"ironladders.tooltip.shift"), shiftDown ? 0xCBCBCB : 0x808080);
        MutableComponent component2 = Component.translatable((String)"ironladders.tooltip.hold_for", (Object[])new Object[]{component1}).withStyle(ChatFormatting.GRAY);
        tooltip.add((Component)component2);
        Component component3 = ClientHelper.componentWithColor((Component)Component.translatable((String)"ironladders.tooltip.morph_upgrade.info_2"), 0xCBCBCB);
        if (shiftDown) {
            tooltip.add((Component)Component.translatable((String)"ironladders.tooltip.hiding_upgrade.info_0").withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"ironladders.tooltip.morph_upgrade.info_1", (Object[])new Object[]{component3}).withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"ironladders.tooltip.morph_upgrade.info_3").withStyle(ChatFormatting.GRAY));
            if (ModList.get().getModContainerById("modernfix").isPresent()) {
                Component mod = ClientHelper.componentWithColor((Component)Component.literal((String)((ModContainer)ModList.get().getModContainerById("modernfix").get()).getModInfo().getDisplayName()), 0xF33838);
                tooltip.add((Component)Component.translatable((String)"ironladders.tooltip.warning.modernfix", (Object[])new Object[]{mod}).withStyle(ChatFormatting.RED));
            }
        }
    }
}

