/*
 * Decompiled with CFR 0.152.
 */
package com.nine.ironladders.datagen;

import com.nine.ironladders.datagen.ILBlockTagProvider;
import com.nine.ironladders.datagen.ILDataMapsProvider;
import com.nine.ironladders.datagen.ILItemTagProvider;
import com.nine.ironladders.datagen.ILLootGenerator;
import com.nine.ironladders.datagen.ILRecipeProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="ironladders", bus=EventBusSubscriber.Bus.MOD)
public class ILDataGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ILBlockTagProvider blockTagsProvider = new ILBlockTagProvider(packOutput, lookupProvider, "ironladders");
        generator.addProvider(true, (DataProvider)blockTagsProvider);
        generator.addProvider(true, (DataProvider)new ILItemTagProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter()));
        event.createProvider(ILRecipeProvider.Runner::new);
        event.createProvider(ILLootGenerator::new);
        generator.addProvider(true, (DataProvider)new ILDataMapsProvider(packOutput, lookupProvider));
    }
}

