/*
 * Decompiled with CFR 0.152.
 */
package com.nine.ironladders.init;

import com.nine.ironladders.common.block.BaseMetalLadder;
import com.nine.ironladders.common.block.CopperLadderBlock;
import com.nine.ironladders.common.block.CryingObsidianLadder;
import com.nine.ironladders.common.utils.LadderType;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class BlockRegistry {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"ironladders");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"ironladders");
    public static final DeferredBlock<Block> WAXED_OXIDIZED_COPPER_LADDER = BlockRegistry.register("waxed_oxidized_copper_ladder", properties -> new CopperLadderBlock((BlockBehaviour.Properties)properties, LadderType.COPPER, WeatheringCopper.WeatherState.OXIDIZED), BlockBehaviour.Properties.of().strength(0.8f, 6.0f).sound(SoundType.COPPER).pushReaction(PushReaction.DESTROY).mapColor(MapColor.WARPED_NYLIUM));
    public static final DeferredBlock<Block> WAXED_WEATHERED_COPPER_LADDER = BlockRegistry.register("waxed_weathered_copper_ladder", properties -> new CopperLadderBlock((BlockBehaviour.Properties)properties, LadderType.COPPER, WeatheringCopper.WeatherState.WEATHERED), BlockBehaviour.Properties.of().strength(0.8f, 6.0f).sound(SoundType.COPPER).pushReaction(PushReaction.DESTROY).mapColor(MapColor.WARPED_STEM));
    public static final DeferredBlock<Block> WAXED_EXPOSED_COPPER_LADDER = BlockRegistry.register("waxed_exposed_copper_ladder", properties -> new CopperLadderBlock((BlockBehaviour.Properties)properties, LadderType.COPPER, WeatheringCopper.WeatherState.EXPOSED), BlockBehaviour.Properties.of().strength(0.8f, 6.0f).sound(SoundType.COPPER).pushReaction(PushReaction.DESTROY).mapColor(MapColor.TERRACOTTA_LIGHT_GRAY));
    public static final DeferredBlock<Block> WAXED_COPPER_LADDER = BlockRegistry.register("waxed_copper_ladder", properties -> new CopperLadderBlock((BlockBehaviour.Properties)properties, LadderType.COPPER, WeatheringCopper.WeatherState.UNAFFECTED), BlockBehaviour.Properties.of().strength(0.8f, 6.0f).sound(SoundType.COPPER).pushReaction(PushReaction.DESTROY).mapColor(MapColor.TERRACOTTA_LIGHT_GRAY));
    public static final DeferredBlock<Block> OXIDIZED_COPPER_LADDER = BlockRegistry.register("oxidized_copper_ladder", properties -> new CopperLadderBlock((BlockBehaviour.Properties)properties, LadderType.COPPER, WeatheringCopper.WeatherState.OXIDIZED), BlockBehaviour.Properties.of().strength(0.8f, 6.0f).sound(SoundType.COPPER).pushReaction(PushReaction.DESTROY).mapColor(MapColor.WARPED_NYLIUM));
    public static final DeferredBlock<Block> WEATHERED_COPPER_LADDER = BlockRegistry.register("weathered_copper_ladder", properties -> new CopperLadderBlock((BlockBehaviour.Properties)properties, LadderType.COPPER, WeatheringCopper.WeatherState.WEATHERED), BlockBehaviour.Properties.of().strength(0.8f, 6.0f).sound(SoundType.COPPER).pushReaction(PushReaction.DESTROY).mapColor(MapColor.WARPED_STEM));
    public static final DeferredBlock<Block> EXPOSED_COPPER_LADDER = BlockRegistry.register("exposed_copper_ladder", properties -> new CopperLadderBlock((BlockBehaviour.Properties)properties, LadderType.COPPER, WeatheringCopper.WeatherState.EXPOSED), BlockBehaviour.Properties.of().strength(0.8f, 6.0f).sound(SoundType.COPPER).pushReaction(PushReaction.DESTROY).mapColor(MapColor.TERRACOTTA_LIGHT_GRAY));
    public static final DeferredBlock<Block> COPPER_LADDER = BlockRegistry.register("copper_ladder", properties -> new CopperLadderBlock((BlockBehaviour.Properties)properties, LadderType.COPPER, WeatheringCopper.WeatherState.UNAFFECTED), BlockBehaviour.Properties.of().strength(0.8f, 6.0f).sound(SoundType.COPPER).pushReaction(PushReaction.DESTROY).mapColor(MapColor.COLOR_ORANGE));
    public static final DeferredBlock<Block> IRON_LADDER = BlockRegistry.register("iron_ladder", properties -> new BaseMetalLadder((BlockBehaviour.Properties)properties, LadderType.IRON), BlockBehaviour.Properties.of().strength(1.5f, 6.0f).sound(SoundType.METAL).requiresCorrectToolForDrops().pushReaction(PushReaction.DESTROY).mapColor(MapColor.METAL));
    public static final DeferredBlock<Block> GOLD_LADDER = BlockRegistry.register("gold_ladder", properties -> new BaseMetalLadder((BlockBehaviour.Properties)properties, LadderType.GOLD), BlockBehaviour.Properties.of().strength(1.2f, 6.0f).sound(SoundType.METAL).requiresCorrectToolForDrops().pushReaction(PushReaction.DESTROY).mapColor(MapColor.GOLD));
    public static final DeferredBlock<Block> DIAMOND_LADDER = BlockRegistry.register("diamond_ladder", properties -> new BaseMetalLadder((BlockBehaviour.Properties)properties, LadderType.DIAMOND), BlockBehaviour.Properties.of().strength(2.5f, 6.0f).sound(SoundType.METAL).requiresCorrectToolForDrops().pushReaction(PushReaction.DESTROY).mapColor(MapColor.DIAMOND));
    public static final DeferredBlock<Block> OBSIDIAN_LADDER = BlockRegistry.register("obsidian_ladder", properties -> new BaseMetalLadder((BlockBehaviour.Properties)properties, LadderType.OBSIDIAN), BlockBehaviour.Properties.of().strength(12.0f, 1200.0f).requiresCorrectToolForDrops().pushReaction(PushReaction.BLOCK).mapColor(MapColor.COLOR_BLACK));
    public static final DeferredBlock<Block> CRYING_OBSIDIAN_LADDER = BlockRegistry.register("crying_obsidian_ladder", properties -> new CryingObsidianLadder((BlockBehaviour.Properties)properties, LadderType.CRYING_OBSIDIAN), BlockBehaviour.Properties.of().strength(12.0f, 1200.0f).requiresCorrectToolForDrops().pushReaction(PushReaction.BLOCK).mapColor(MapColor.COLOR_BLACK));
    public static final DeferredBlock<Block> NETHERITE_LADDER = BlockRegistry.register("netherite_ladder", properties -> new BaseMetalLadder((BlockBehaviour.Properties)properties, LadderType.NETHERITE), BlockBehaviour.Properties.of().strength(5.0f, 1200.0f).requiresCorrectToolForDrops().pushReaction(PushReaction.BLOCK).sound(SoundType.NETHERITE_BLOCK).mapColor(MapColor.COLOR_BLACK), new Item.Properties().fireResistant());
    public static final DeferredBlock<Block> BEDROCK_LADDER = BlockRegistry.register("bedrock_ladder", properties -> new BaseMetalLadder((BlockBehaviour.Properties)properties, LadderType.BEDROCK), BlockBehaviour.Properties.of().strength(-1.0f, 3600000.0f).pushReaction(PushReaction.BLOCK).mapColor(MapColor.STONE).noLootTable());
    public static final DeferredBlock<Block> STEEL_LADDER = BlockRegistry.register("steel_ladder", properties -> new BaseMetalLadder((BlockBehaviour.Properties)properties, LadderType.STEEL), BlockBehaviour.Properties.of().strength(2.0f, 9.0f).sound(SoundType.METAL).requiresCorrectToolForDrops().pushReaction(PushReaction.DESTROY).mapColor(MapColor.DEEPSLATE));
    public static final DeferredBlock<Block> TIN_LADDER = BlockRegistry.register("tin_ladder", properties -> new BaseMetalLadder((BlockBehaviour.Properties)properties, LadderType.TIN), BlockBehaviour.Properties.of().strength(5.0f, 6.0f).sound(SoundType.METAL).requiresCorrectToolForDrops().pushReaction(PushReaction.DESTROY).mapColor(MapColor.TERRACOTTA_WHITE));
    public static final DeferredBlock<Block> LEAD_LADDER = BlockRegistry.register("lead_ladder", properties -> new BaseMetalLadder((BlockBehaviour.Properties)properties, LadderType.LEAD), BlockBehaviour.Properties.of().strength(5.0f, 9.0f).sound(SoundType.METAL).requiresCorrectToolForDrops().pushReaction(PushReaction.DESTROY).mapColor(MapColor.COLOR_LIGHT_GRAY));
    public static final DeferredBlock<Block> BRONZE_LADDER = BlockRegistry.register("bronze_ladder", properties -> new BaseMetalLadder((BlockBehaviour.Properties)properties, LadderType.BRONZE), BlockBehaviour.Properties.of().strength(5.0f, 9.0f).sound(SoundType.METAL).requiresCorrectToolForDrops().pushReaction(PushReaction.DESTROY).mapColor(MapColor.COLOR_ORANGE));
    public static final DeferredBlock<Block> SILVER_LADDER = BlockRegistry.register("silver_ladder", properties -> new BaseMetalLadder((BlockBehaviour.Properties)properties, LadderType.SILVER), BlockBehaviour.Properties.of().strength(3.0f, 4.0f).sound(SoundType.METAL).requiresCorrectToolForDrops().pushReaction(PushReaction.DESTROY).mapColor(MapColor.TERRACOTTA_WHITE));
    public static final DeferredBlock<Block> ALUMINUM_LADDER = BlockRegistry.register("aluminum_ladder", properties -> new BaseMetalLadder((BlockBehaviour.Properties)properties, LadderType.ALUMINUM), BlockBehaviour.Properties.of().strength(2.0f, 3.0f).sound(SoundType.METAL).pushReaction(PushReaction.DESTROY).mapColor(MapColor.TERRACOTTA_WHITE));

    public static <T extends Block> DeferredBlock<T> register(String name, Function<BlockBehaviour.Properties, T> factory, BlockBehaviour.Properties properties) {
        return BlockRegistry.register(name, factory, properties, new Item.Properties());
    }

    public static <T extends Block> DeferredBlock<T> register(String name, Function<BlockBehaviour.Properties, T> factory, BlockBehaviour.Properties blockProps, Item.Properties itemProps) {
        DeferredBlock ret = BLOCKS.register(name, () -> (Block)factory.apply(blockProps.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ironladders", (String)name)))));
        ITEMS.registerSimpleBlockItem(name, (Supplier)ret, itemProps);
        return ret;
    }
}

