/*
 * Decompiled with CFR 0.152.
 */
package com.nine.ironladders.mixin;

import com.nine.ironladders.common.block.BaseMetalLadder;
import com.nine.ironladders.common.item.MorphUpgradeItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayerGameMode.class})
public class ServerPlayerGameModeMixin {
    @Shadow
    @Final
    protected ServerPlayer player;
    @Shadow
    protected ServerLevel level;

    @Inject(method={"handleBlockBreakAction"}, at={@At(value="HEAD")}, cancellable=true)
    public void handleBlockBreakAction(BlockPos pos, ServerboundPlayerActionPacket.Action action, Direction face, int maxBuildHeight, int sequence, CallbackInfo ci) {
        Item item;
        ItemStack stack = this.player.getMainHandItem();
        if (action == ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK && (item = stack.getItem()) instanceof MorphUpgradeItem) {
            MorphUpgradeItem morphUpgradeItem = (MorphUpgradeItem)item;
            if (this.player.isShiftKeyDown() && this.level.getBlockState(pos).getBlock() instanceof BaseMetalLadder) {
                if (!this.player.getCooldowns().isOnCooldown(stack) && this.player.isShiftKeyDown()) {
                    morphUpgradeItem.morphMultipleLadders((Player)this.player, stack, (Level)this.level, pos);
                }
                ci.cancel();
            }
        }
    }
}

