/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.item_descriptions.client.helpers;

import cc.cassian.item_descriptions.client.config.ModConfig;
import cc.cassian.item_descriptions.client.helpers.ModHelpers;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class GenericKeys {
    @NotNull
    public static String getGenericLoreKey(String loreKey) {
        if (!ModConfig.get().developer_disableGenericStringDescriptions) {
            if (loreKey.contains("planks")) {
                return "lore.generic.planks";
            }
            if (loreKey.contains("_sword")) {
                return "lore.generic.sword";
            }
            if (loreKey.contains("_hoe")) {
                return "lore.generic.hoe";
            }
            if (loreKey.contains("_shovel")) {
                return "lore.generic.shovel";
            }
            if (loreKey.contains("_pickaxe")) {
                return "lore.generic.pickaxe";
            }
            if (loreKey.contains("_axe")) {
                return "lore.generic.axe";
            }
            if (loreKey.contains("stripped_")) {
                return "lore.generic.stripped_log";
            }
            if (loreKey.contains("horse_armor")) {
                return "lore.generic.horse_armor";
            }
            if (loreKey.contains("tipped_arrow")) {
                return "lore.minecraft.tipped_arrow";
            }
            if (loreKey.contains("splash_potion")) {
                return "lore.minecraft.splash_potion";
            }
            if (loreKey.contains("lingering_potion")) {
                return "lore.minecraft.lingering_potion";
            }
            if (loreKey.contains("potion")) {
                return "lore.minecraft.potion";
            }
            if (loreKey.contains("smithing_template")) {
                return "lore.generic.smithing_template";
            }
            if (loreKey.contains("helmet")) {
                return "lore.generic.helmet";
            }
            if (loreKey.contains("chestplate")) {
                return "lore.generic.chestplate";
            }
            if (loreKey.contains("leggings")) {
                return "lore.generic.leggings";
            }
            if (loreKey.contains("boots")) {
                return "lore.generic.boots";
            }
            if (loreKey.contains("wool")) {
                return "lore.generic.wool";
            }
            if (loreKey.contains("lamp")) {
                return "lore.generic.lamp";
            }
            if (loreKey.contains("turf")) {
                return "lore.generic.turf";
            }
            if (loreKey.contains("carpet")) {
                return "lore.generic.carpet";
            }
            if (loreKey.contains("dead_")) {
                return "lore.generic.dead_coral";
            }
            if (loreKey.contains("coral_block")) {
                return "lore.generic.coral_block";
            }
            if (loreKey.contains("coral")) {
                return "lore.generic.coral";
            }
            if (loreKey.contains("froglight")) {
                return "lore.generic.froglight";
            }
            if (loreKey.contains("spawn_egg")) {
                return "lore.generic.spawn_egg";
            }
            if (loreKey.contains("_stem")) {
                return "lore.generic.stem";
            }
            if (loreKey.contains("_wood") || loreKey.contains("_hyphae")) {
                return "lore.generic.wood";
            }
            if (loreKey.contains("_log")) {
                return "lore.generic.log";
            }
            if (loreKey.contains("_hanging_sign")) {
                return "lore.generic.hanging_sign";
            }
            if (loreKey.contains("_sign")) {
                return "lore.generic.sign";
            }
            if (loreKey.contains("shulker_box")) {
                return "lore.generic.shulker_box";
            }
            if (loreKey.contains("lantern")) {
                return "lore.generic.lantern";
            }
            if (loreKey.contains("button")) {
                return "lore.generic.button";
            }
            if (loreKey.contains("_sapling") || loreKey.contains("_propagule")) {
                return "lore.generic.sapling";
            }
            if (loreKey.contains("_pressure_plate")) {
                return "lore.generic.pressure_plate";
            }
            if (loreKey.contains("_stairs")) {
                return "lore.generic.stairs";
            }
            if (loreKey.contains("wall_gate")) {
                return "lore.generic.wall_gate";
            }
            if (loreKey.contains("wall")) {
                return "lore.generic.wall";
            }
            if (loreKey.contains("fence_gate")) {
                return "lore.generic.fence_gate";
            }
            if (loreKey.contains("fence")) {
                return "lore.generic.fence";
            }
            if (loreKey.contains("_slab")) {
                return "lore.generic.slab";
            }
            if (loreKey.contains("trapdoor")) {
                return "lore.generic.trapdoor";
            }
            if (loreKey.contains("door")) {
                return "lore.generic.door";
            }
            if (loreKey.contains("waxed")) {
                return "lore.generic.waxed";
            }
            if (loreKey.contains("stained_glass")) {
                return "lore.generic.stained_glass";
            }
            if (loreKey.contains("glass")) {
                return "lore.generic.glass";
            }
            if (loreKey.contains("sherd")) {
                return "lore.generic.sherd";
            }
            if (loreKey.contains("leaves")) {
                return "lore.generic.leaves";
            }
            if (loreKey.contains("infested")) {
                return "lore.generic.infested";
            }
            if (loreKey.contains("banner_pattern")) {
                return "lore.generic.banner_pattern";
            }
            if (loreKey.contains("head") || loreKey.contains("skull")) {
                return "lore.generic.skull";
            }
            if (loreKey.contains("cake")) {
                return "lore.generic.cake";
            }
            if (loreKey.contains("candle")) {
                return "lore.generic.candle";
            }
            if (loreKey.contains("dye")) {
                return "lore.generic.dye";
            }
            if (loreKey.contains("music_disc")) {
                return "lore.generic.music_disc";
            }
            if (loreKey.contains("banner")) {
                return "lore.generic.banner";
            }
            if (loreKey.contains("concrete_powder")) {
                return "lore.generic.concrete_powder";
            }
            if (loreKey.contains("concrete")) {
                return "lore.generic.concrete";
            }
            if (loreKey.contains("glazed_terracotta")) {
                return "lore.generic.glazed_terracotta";
            }
            if (loreKey.contains("terracotta")) {
                return "lore.generic.terracotta";
            }
            if (loreKey.contains("bed")) {
                return "lore.generic.bed";
            }
            if (loreKey.contains("chest_boat") || loreKey.contains("chest_raft")) {
                return "lore.generic.chest_boat";
            }
            if (loreKey.contains("boat") || loreKey.contains("_raft")) {
                return "lore.generic.boat";
            }
            if (loreKey.contains("bricks")) {
                return "lore.generic.bricks";
            }
            if (loreKey.contains("chiseled")) {
                return "lore.generic.chiseled";
            }
            if (loreKey.contains("smooth_")) {
                return "lore.generic.smooth";
            }
            if (loreKey.contains("bars")) {
                return "lore.generic.bars";
            }
            if (loreKey.contains("cut_")) {
                return "lore.generic.cut";
            }
            if (loreKey.contains("crafting_table")) {
                return "lore.generic.crafting_table";
            }
            if (loreKey.contains("torch_lever")) {
                return "lore.generic.torch_lever";
            }
            if (loreKey.contains("torch")) {
                return "lore.generic.torch";
            }
            if (loreKey.contains("ladder")) {
                return "lore.generic.ladder";
            }
            return "";
        }
        return loreKey;
    }

    private static String checkGenericTagList(Object object) {
        if (object instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)object;
            Item item = itemStack.getItem();
            if (item instanceof SpawnEggItem) {
                return "tag.c.spawn_egg.description";
            }
            String[] returnedKey = new String[1];
            itemStack.getTags().forEach(itemTagKey -> {
                String loreKey = "tag." + itemTagKey.location().toLanguageKey() + ".description";
                if (I18n.exists((String)loreKey) && (returnedKey[0] == null || returnedKey[0].length() < loreKey.length())) {
                    returnedKey[0] = loreKey;
                }
            });
            if (returnedKey[0] == null && item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                blockItem.getBlock().defaultBlockState().getTags().forEach(itemTagKey -> {
                    String loreKey = "tag." + itemTagKey.location().toLanguageKey() + ".description";
                    if (I18n.exists((String)loreKey) && (returnedKey[0] == null || returnedKey[0].length() < loreKey.length())) {
                        returnedKey[0] = loreKey;
                    }
                });
            }
            return returnedKey[0];
        }
        if (object instanceof BlockState) {
            BlockState state = (BlockState)object;
            String[] returnedKey = new String[1];
            state.getTags().forEach(itemTagKey -> {
                String loreKey = "tag." + itemTagKey.location().toLanguageKey() + ".description";
                if (I18n.exists((String)loreKey) && (returnedKey[0] == null || returnedKey[0].length() < loreKey.length())) {
                    returnedKey[0] = loreKey;
                }
            });
            return returnedKey[0];
        }
        if (object instanceof Entity) {
            Entity entity = (Entity)object;
            String[] returnedKey = new String[1];
            entity.getType().builtInRegistryHolder().tags().forEach(itemTagKey -> {
                String loreKey = "tag." + itemTagKey.location().toLanguageKey() + ".description";
                if (I18n.exists((String)loreKey) && (returnedKey[0] == null || returnedKey[0].length() < loreKey.length())) {
                    returnedKey[0] = loreKey;
                }
            });
            return returnedKey[0];
        }
        return "";
    }

    public static String getGenericKey(Object object) {
        String loreKey = ModHelpers.getLoreTranslationKey(object);
        if (!ModConfig.get().developer_disableGenericTagDescriptions) {
            String generic = GenericKeys.checkGenericTagList(object);
            if (generic != null) {
                if (generic.isEmpty()) {
                    return GenericKeys.getGenericLoreKey(loreKey);
                }
                return generic;
            }
            return GenericKeys.getGenericLoreKey(loreKey);
        }
        return GenericKeys.getGenericLoreKey(loreKey);
    }
}

