/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.item_descriptions.client.helpers;

import cc.cassian.item_descriptions.client.config.ModConfig;
import cc.cassian.item_descriptions.client.helpers.GenericKeys;
import cc.cassian.item_descriptions.client.helpers.neoforge.ModHelpersImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ModHelpers {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean clothConfigInstalled() {
        return ModHelpersImpl.clothConfigInstalled();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean tooltipFixInstalled() {
        return ModHelpersImpl.tooltipFixInstalled();
    }

    public static Style getStyle() {
        return Style.EMPTY.withColor(ModHelpers.getColour()).withItalic(Boolean.valueOf(ModConfig.get().style_italics)).withBold(Boolean.valueOf(ModConfig.get().style_bold));
    }

    public static TextColor getColour() {
        String replacedColour;
        String colour = ModConfig.get().style_color;
        int length = colour.length();
        if (length == 1) {
            return TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.getByCode((char)colour.charAt(0)));
        }
        return switch (replacedColour = colour.toLowerCase().replace(" ", "_")) {
            case "black", "dark_blue", "dark_green", "dark_red", "dark_purple", "blue", "green", "aqua", "red", "yellow", "white" -> TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.getByName((String)colour));
            case "pink", "light_purple" -> TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.getByName((String)"light_purple"));
            case "dark_gray", "dark_grey" -> TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.getByName((String)"dark_gray"));
            case "cyan", "dark_aqua" -> TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.getByName((String)"dark_aqua"));
            case "orange", "gold", "dark_yellow" -> TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.getByName((String)"gold"));
            default -> TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.getByName((String)"gray"));
        };
    }

    public static int getIndex(String translatedKey, int maxLength) {
        String subKey = translatedKey.substring(0, maxLength);
        int index = subKey.contains(" ") ? subKey.lastIndexOf(" ") + 1 : maxLength;
        return index;
    }

    public static boolean tooltipKeyPressed() {
        if (ModConfig.get().keybind_displayWhenControlIsHeld && Screen.hasControlDown()) {
            return ModHelpers.checkKey(Screen.hasControlDown());
        }
        if (ModConfig.get().keybind_displayWhenShiftIsHeld && Screen.hasShiftDown()) {
            return ModHelpers.checkKey(Screen.hasShiftDown());
        }
        if (ModConfig.get().keybind_displayWhenAltIsHeld && Screen.hasAltDown()) {
            return ModHelpers.checkKey(Screen.hasAltDown());
        }
        return false;
    }

    public static boolean checkKey(boolean key) {
        boolean invert = ModConfig.get().keybind_invert;
        if (key) {
            return !invert;
        }
        if (!key) {
            return invert;
        }
        return false;
    }

    public static String findItemLoreKey(ItemStack stack) {
        String profileKey;
        if (ModHelpers.hasComponent(stack, DataComponents.CUSTOM_MODEL_DATA)) {
            CustomModelData data = Objects.requireNonNull((CustomModelData)stack.getComponents().get(DataComponents.CUSTOM_MODEL_DATA));
            String dataValue = data.getString(0);
            String modelKey = ModHelpers.getLoreKey(stack) + ".custommodeldata." + dataValue;
            if (ModHelpers.hasTranslation(modelKey)) {
                return modelKey;
            }
        } else if (ModHelpers.hasComponent(stack, DataComponents.PROFILE) && ModHelpers.hasTranslation(profileKey = ModHelpers.getProfile(stack))) {
            return profileKey;
        }
        return ModHelpers.checkLoreKey(ModHelpers.getLoreKey(stack));
    }

    public static String getBlockAccessorLoreKey(Block block, Level world, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        String profileKey;
        String loreKey = ModHelpers.findBlockLoreKey(block);
        if (blockEntity instanceof SkullBlockEntity && ModHelpers.hasTranslation(profileKey = ModHelpers.getProfile(blockEntity, loreKey))) {
            return profileKey;
        }
        if (!ModHelpers.hasTranslation(loreKey)) {
            return ModHelpers.findItemLoreKey(block.defaultBlockState().getCloneItemStack((LevelReader)world, pos, true));
        }
        return loreKey;
    }

    public static boolean hasComponent(ItemStack stack, DataComponentType<?> type) {
        return stack.getComponents().has(type);
    }

    public static String getProfile(ItemStack stack) {
        String profileKey;
        Optional optionalProfileName = Objects.requireNonNull(Objects.requireNonNull((ResolvableProfile)stack.getComponents().get(DataComponents.PROFILE)).name());
        if (!optionalProfileName.isEmpty() && ModHelpers.hasTranslation(profileKey = ModHelpers.getLoreKey(stack) + ".profile." + ModHelpers.getProfileName(optionalProfileName))) {
            return profileKey;
        }
        return "";
    }

    public static String getProfile(BlockEntity blockEntity, String loreKey) {
        Optional optionalProfileName;
        try {
            optionalProfileName = Objects.requireNonNull(((SkullBlockEntity)blockEntity).getOwnerProfile()).name();
        }
        catch (NullPointerException nullPointerException) {
            return loreKey;
        }
        String profileKey = loreKey + ".profile." + ModHelpers.getProfileName(optionalProfileName);
        if (ModHelpers.hasTranslation(profileKey)) {
            return profileKey;
        }
        return loreKey;
    }

    public static boolean showBlockDescriptions() {
        return ModConfig.get().blockDescriptions && (ModHelpers.tooltipKeyPressed() || ModConfig.get().displayBlockDescriptionsAlways);
    }

    public static boolean showItemDescriptions() {
        return ModConfig.get().itemDescriptions && (ModHelpers.tooltipKeyPressed() || ModConfig.get().displayAlways);
    }

    public static boolean showEntityDescriptions() {
        return ModConfig.get().entityDescriptions && (ModHelpers.tooltipKeyPressed() || ModConfig.get().displayEntityDescriptionsAlways);
    }

    public static String getProfileName(Optional<String> optionalProfileName) {
        if (optionalProfileName.isPresent()) {
            String profileName = optionalProfileName.get();
            return profileName;
        }
        return "";
    }

    public static String getProfileName(String optionalProfileName) {
        return optionalProfileName;
    }

    public static String findBlockLoreKey(Block block) {
        return ModHelpers.checkLoreKey(ModHelpers.getLoreKey(block));
    }

    public static String findEntityLoreKey(Entity entity) {
        return ModHelpers.checkLoreKey(ModHelpers.getLoreKey(entity));
    }

    public static String checkLoreKey(String loreKey) {
        if (!ModConfig.get().developer_dontTranslate) {
            if (ModHelpers.hasTranslation(loreKey)) {
                return loreKey;
            }
            return GenericKeys.getGenericLoreKey(loreKey);
        }
        return loreKey;
    }

    @NotNull
    private static String getLoreKey(Object object) {
        @NotNull String key = ModHelpers.getLoreTranslationKey(object);
        if (ModHelpers.hasTranslation(key)) {
            return key;
        }
        return GenericKeys.getGenericKey(object);
    }

    @NotNull
    public static String convertToLoreKey(String translationKey) {
        String loreKey;
        if (translationKey.contains("block.")) {
            loreKey = translationKey.replaceFirst("block", "lore");
        } else if (translationKey.contains("item.")) {
            loreKey = translationKey.replaceFirst("item", "lore");
        } else {
            if (translationKey.contains("entity.")) {
                String oldKey = translationKey.replaceFirst("entity", "lore");
                Object newKey = translationKey + ".description";
                if (((String)newKey).contains("tropical_fish")) {
                    newKey = "entity.minecraft.tropical_fish";
                }
                if (ModHelpers.hasTranslation((String)newKey)) {
                    return newKey;
                }
                if (ModHelpers.hasTranslation(oldKey)) {
                    return oldKey;
                }
                return newKey;
            }
            loreKey = translationKey;
        }
        return loreKey;
    }

    @NotNull
    public static String getLoreTranslationKey(Object object) {
        if (object instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            return ModHelpers.convertToLoreKey(stack.getItem().getDescriptionId());
        }
        if (object instanceof Block) {
            Block block = (Block)object;
            return ModHelpers.convertToLoreKey(block.getDescriptionId());
        }
        if (object instanceof Entity) {
            Entity entity = (Entity)object;
            return ModHelpers.convertToLoreKey(ModHelpers.getEntityTranslationKey(entity));
        }
        return "";
    }

    public static String getEntityTranslationKey(Entity entity) {
        if (entity.isAlwaysTicking()) {
            String playerKey = "entity.minecraft.player." + entity.getName().tryCollapseToString();
            if (ModHelpers.hasTranslation(playerKey)) {
                return playerKey;
            }
            return "entity.minecraft.player";
        }
        return entity.getType().getDescriptionId();
    }

    public static String translate(String key) {
        if (!ModConfig.get().developer_dontTranslate) {
            return I18n.get((String)key, (Object[])new Object[0]);
        }
        return key;
    }

    public static boolean hasTranslation(String key) {
        if (!ModConfig.get().developer_showUntranslated) {
            return I18n.exists((String)key);
        }
        return true;
    }

    public static List<Component> createTooltip(String loreKey, boolean wrap) {
        ArrayList<Component> lines = new ArrayList<Component>();
        int maxLength = ModConfig.get().style_length;
        if (!loreKey.isBlank()) {
            String translatedKey = ModHelpers.translate(loreKey);
            if (ModHelpers.hasTranslation(loreKey)) {
                if (wrap && maxLength != 0) {
                    while (translatedKey.length() >= maxLength) {
                        int index = ModHelpers.getIndex(translatedKey, maxLength);
                        lines.add((Component)Component.literal((String)translatedKey.substring(0, index)).setStyle(ModHelpers.getStyle()));
                        translatedKey = translatedKey.substring(index);
                    }
                }
                if (!translatedKey.isBlank()) {
                    lines.add((Component)Component.literal((String)translatedKey).setStyle(ModHelpers.getStyle()));
                }
            }
        }
        return lines;
    }

    public static Component createMultilineTranslation(String loreKey) {
        StringBuilder lines = new StringBuilder();
        if (!loreKey.isEmpty()) {
            String translatedKey = ModHelpers.translate(loreKey);
            if (ModHelpers.hasTranslation(loreKey)) {
                lines.append(translatedKey);
            }
        }
        return Component.literal((String)String.valueOf(lines));
    }

    public static Component fieldName(Field field) {
        return Component.translatable((String)("config.item-descriptions.config." + field.getName()));
    }

    public static Component[] fieldTooltip(Field field) {
        String tooltipKey = "config.item-descriptions.config." + field.getName() + ".tooltip";
        return ModHelpers.createTooltip(tooltipKey, true).toArray(new Component[0]);
    }

    public static <T> T fieldGet(Object instance, Field field) {
        try {
            return (T)field.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Consumer<T> fieldSetter(Object instance, Field field) {
        return t -> {
            try {
                field.set(instance, t);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        };
    }
}

