/*
 * Decompiled with CFR 0.152.
 */
package nicusha.ruby.materials;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public record RubyToolMaterials(TagKey<Block> incorrectBlocksForDrops, int durability, float speed, float attackDamageBonus, int enchantmentValue, TagKey<Item> repairItems) {
    public static final ToolMaterial OPAL = new ToolMaterial(BlockTags.INCORRECT_FOR_IRON_TOOL, 1200, 1.8f, 1.0f, 8, ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)"opal_repair")));
    public static final ToolMaterial RUBY = new ToolMaterial(BlockTags.INCORRECT_FOR_DIAMOND_TOOL, 4096, 1.3f, 5.0f, 8, ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)"ruby_repair")));
    public static final ToolMaterial METEORITE = new ToolMaterial(BlockTags.INCORRECT_FOR_IRON_TOOL, 8521, 0.8f, 4.0f, 12, ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)"meteorite_gem")));
    public static final ToolMaterial AMETHYST = new ToolMaterial(BlockTags.INCORRECT_FOR_NETHERITE_TOOL, 6723, 1.6f, 4.0f, 30, ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)"amethyst_repair")));
    public static final ToolMaterial BRAUNITE = new ToolMaterial(BlockTags.INCORRECT_FOR_NETHERITE_TOOL, 6723, 1.0f, 2.0f, 15, ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)"braunite_gem")));

    private Item.Properties applyCommonProperties(Item.Properties properties) {
        return properties.durability(this.durability).repairable(this.repairItems).enchantable(this.enchantmentValue);
    }

    public Item.Properties applyToolProperties(Item.Properties properties, TagKey<Block> mineableBlocks, float attackDamage, float attackSpeed) {
        HolderGetter holdergetter = BuiltInRegistries.acquireBootstrapRegistrationLookup((Registry)BuiltInRegistries.BLOCK);
        return this.applyCommonProperties(properties).component(DataComponents.TOOL, (Object)new Tool(List.of(Tool.Rule.deniesDrops((HolderSet)holdergetter.getOrThrow(this.incorrectBlocksForDrops)), Tool.Rule.minesAndDrops((HolderSet)holdergetter.getOrThrow(mineableBlocks), (float)this.speed)), 1.0f, 1)).attributes(this.createToolAttributes(attackDamage, attackSpeed));
    }

    private ItemAttributeModifiers createToolAttributes(float attackDamage, float attackSpeed) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, (double)(attackDamage + this.attackDamageBonus), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, (double)attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public Item.Properties applySwordProperties(Item.Properties properties, float attackDamage, float attackSpeed) {
        HolderGetter holdergetter = BuiltInRegistries.acquireBootstrapRegistrationLookup((Registry)BuiltInRegistries.BLOCK);
        return this.applyCommonProperties(properties).component(DataComponents.TOOL, (Object)new Tool(List.of(Tool.Rule.minesAndDrops((HolderSet)HolderSet.direct((Holder[])new Holder[]{Blocks.COBWEB.builtInRegistryHolder()}), (float)15.0f), Tool.Rule.overrideSpeed((HolderSet)holdergetter.getOrThrow(BlockTags.SWORD_EFFICIENT), (float)1.5f)), 1.0f, 2)).attributes(this.createSwordAttributes(attackDamage, attackSpeed));
    }

    private ItemAttributeModifiers createSwordAttributes(float attackDamage, float attackSpeed) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, (double)(attackDamage + this.attackDamageBonus), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, (double)attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }
}

