/*
 * Decompiled with CFR 0.152.
 */
package nicusha.ruby.registry;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import nicusha.ruby.materials.RubyArmorMaterials;
import nicusha.ruby.materials.RubyToolMaterials;

public class ItemRegistry {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"ruby");
    public static final DeferredItem<Item> BRAUNITE_GEM = ItemRegistry.createItem("braunite_gem", false);
    public static final DeferredItem<Item> METEORITE_GEM = ItemRegistry.createItem("meteorite_gem", true);
    public static final DeferredItem<Item> OPAL_GEM = ItemRegistry.createItem("opal_gem", false);
    public static final DeferredItem<Item> RUBY_GEM = ItemRegistry.createItem("ruby_gem", false);
    public static final DeferredItem<Item> AMETHYST_SWORD = ItemRegistry.createSwordItem("amethyst_sword", RubyToolMaterials.AMETHYST, false);
    public static final DeferredItem<Item> BRAUNITE_SWORD = ItemRegistry.createSwordItem("braunite_sword", RubyToolMaterials.BRAUNITE, false);
    public static final DeferredItem<Item> METEORITE_SWORD = ItemRegistry.createSwordItem("meteorite_sword", RubyToolMaterials.METEORITE, false);
    public static final DeferredItem<Item> OPAL_SWORD = ItemRegistry.createSwordItem("opal_sword", RubyToolMaterials.OPAL, false);
    public static final DeferredItem<Item> RUBY_SWORD = ItemRegistry.createSwordItem("ruby_sword", RubyToolMaterials.RUBY, false);
    public static final DeferredItem<Item> AMETHYST_PICKAXE = ItemRegistry.createPickaxeItem("amethyst_pickaxe", RubyToolMaterials.AMETHYST, false);
    public static final DeferredItem<Item> BRAUNITE_PICKAXE = ItemRegistry.createPickaxeItem("braunite_pickaxe", RubyToolMaterials.BRAUNITE, false);
    public static final DeferredItem<Item> METEORITE_PICKAXE = ItemRegistry.createPickaxeItem("meteorite_pickaxe", RubyToolMaterials.METEORITE, false);
    public static final DeferredItem<Item> OPAL_PICKAXE = ItemRegistry.createPickaxeItem("opal_pickaxe", RubyToolMaterials.OPAL, false);
    public static final DeferredItem<Item> RUBY_PICKAXE = ItemRegistry.createPickaxeItem("ruby_pickaxe", RubyToolMaterials.RUBY, false);
    public static final DeferredItem<Item> AMETHYST_AXE = ItemRegistry.createAxeItem("amethyst_axe", RubyToolMaterials.AMETHYST, false);
    public static final DeferredItem<Item> BRAUNITE_AXE = ItemRegistry.createAxeItem("braunite_axe", RubyToolMaterials.BRAUNITE, false);
    public static final DeferredItem<Item> METEORITE_AXE = ItemRegistry.createAxeItem("meteorite_axe", RubyToolMaterials.METEORITE, false);
    public static final DeferredItem<Item> OPAL_AXE = ItemRegistry.createAxeItem("opal_axe", RubyToolMaterials.OPAL, false);
    public static final DeferredItem<Item> RUBY_AXE = ItemRegistry.createAxeItem("ruby_axe", RubyToolMaterials.RUBY, false);
    public static final DeferredItem<Item> AMETHYST_SHOVEL = ItemRegistry.createShovelItem("amethyst_shovel", RubyToolMaterials.AMETHYST, false);
    public static final DeferredItem<Item> BRAUNITE_SHOVEL = ItemRegistry.createShovelItem("braunite_shovel", RubyToolMaterials.BRAUNITE, false);
    public static final DeferredItem<Item> METEORITE_SHOVEL = ItemRegistry.createShovelItem("meteorite_shovel", RubyToolMaterials.METEORITE, false);
    public static final DeferredItem<Item> OPAL_SHOVEL = ItemRegistry.createShovelItem("opal_shovel", RubyToolMaterials.OPAL, false);
    public static final DeferredItem<Item> RUBY_SHOVEL = ItemRegistry.createShovelItem("ruby_shovel", RubyToolMaterials.RUBY, false);
    public static final DeferredItem<Item> AMETHYST_HOE = ItemRegistry.createHoeItem("amethyst_hoe", RubyToolMaterials.AMETHYST, false);
    public static final DeferredItem<Item> BRAUNITE_HOE = ItemRegistry.createHoeItem("braunite_hoe", RubyToolMaterials.BRAUNITE, false);
    public static final DeferredItem<Item> METEORITE_HOE = ItemRegistry.createHoeItem("meteorite_hoe", RubyToolMaterials.METEORITE, false);
    public static final DeferredItem<Item> OPAL_HOE = ItemRegistry.createHoeItem("opal_hoe", RubyToolMaterials.OPAL, false);
    public static final DeferredItem<Item> RUBY_HOE = ItemRegistry.createHoeItem("ruby_hoe", RubyToolMaterials.RUBY, false);
    public static final DeferredItem<Item> AMETHYST_HELMET = ItemRegistry.createArmorItem("amethyst_helmet", RubyArmorMaterials.AMETHYST, ArmorType.HELMET, false, 350);
    public static final DeferredItem<Item> AMETHYST_CHESTPLATE = ItemRegistry.createArmorItem("amethyst_chestplate", RubyArmorMaterials.AMETHYST, ArmorType.CHESTPLATE, false, 500);
    public static final DeferredItem<Item> AMETHYST_LEGGINGS = ItemRegistry.createArmorItem("amethyst_leggings", RubyArmorMaterials.AMETHYST, ArmorType.LEGGINGS, false, 455);
    public static final DeferredItem<Item> AMETHYST_BOOTS = ItemRegistry.createArmorItem("amethyst_boots", RubyArmorMaterials.AMETHYST, ArmorType.BOOTS, false, 325);
    public static final DeferredItem<Item> BRAUNITE_HELMET = ItemRegistry.createArmorItem("braunite_helmet", RubyArmorMaterials.BRAUNITE, ArmorType.HELMET, false, 555);
    public static final DeferredItem<Item> BRAUNITE_CHESTPLATE = ItemRegistry.createArmorItem("braunite_chestplate", RubyArmorMaterials.BRAUNITE, ArmorType.CHESTPLATE, false, 750);
    public static final DeferredItem<Item> BRAUNITE_LEGGINGS = ItemRegistry.createArmorItem("braunite_leggings", RubyArmorMaterials.BRAUNITE, ArmorType.LEGGINGS, false, 700);
    public static final DeferredItem<Item> BRAUNITE_BOOTS = ItemRegistry.createArmorItem("braunite_boots", RubyArmorMaterials.BRAUNITE, ArmorType.BOOTS, false, 525);
    public static final DeferredItem<Item> METEORITE_HELMET = ItemRegistry.createArmorItem("meteorite_helmet", RubyArmorMaterials.METEORITE, ArmorType.HELMET, false, 4050);
    public static final DeferredItem<Item> METEORITE_CHESTPLATE = ItemRegistry.createArmorItem("meteorite_chestplate", RubyArmorMaterials.METEORITE, ArmorType.CHESTPLATE, false, 6250);
    public static final DeferredItem<Item> METEORITE_LEGGINGS = ItemRegistry.createArmorItem("meteorite_leggings", RubyArmorMaterials.METEORITE, ArmorType.LEGGINGS, false, 5800);
    public static final DeferredItem<Item> METEORITE_BOOTS = ItemRegistry.createArmorItem("meteorite_boots", RubyArmorMaterials.METEORITE, ArmorType.BOOTS, false, 3750);
    public static final DeferredItem<Item> OPAL_HELMET = ItemRegistry.createArmorItem("opal_helmet", RubyArmorMaterials.OPAL, ArmorType.HELMET, false, 350);
    public static final DeferredItem<Item> OPAL_CHESTPLATE = ItemRegistry.createArmorItem("opal_chestplate", RubyArmorMaterials.OPAL, ArmorType.CHESTPLATE, false, 500);
    public static final DeferredItem<Item> OPAL_LEGGINGS = ItemRegistry.createArmorItem("opal_leggings", RubyArmorMaterials.OPAL, ArmorType.LEGGINGS, false, 455);
    public static final DeferredItem<Item> OPAL_BOOTS = ItemRegistry.createArmorItem("opal_boots", RubyArmorMaterials.OPAL, ArmorType.BOOTS, false, 325);
    public static final DeferredItem<Item> RUBY_HELMET = ItemRegistry.createArmorItem("ruby_helmet", RubyArmorMaterials.RUBY, ArmorType.HELMET, false, 1020);
    public static final DeferredItem<Item> RUBY_CHESTPLATE = ItemRegistry.createArmorItem("ruby_chestplate", RubyArmorMaterials.RUBY, ArmorType.CHESTPLATE, false, 1550);
    public static final DeferredItem<Item> RUBY_LEGGINGS = ItemRegistry.createArmorItem("ruby_leggings", RubyArmorMaterials.RUBY, ArmorType.LEGGINGS, false, 1300);
    public static final DeferredItem<Item> RUBY_BOOTS = ItemRegistry.createArmorItem("ruby_boots", RubyArmorMaterials.RUBY, ArmorType.BOOTS, false, 980);

    private static DeferredItem<Item> createItem(String name, boolean isFireProof) {
        if (isFireProof) {
            return ITEMS.register(name, () -> new Item(new Item.Properties().fireResistant().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)name)))));
        }
        return ITEMS.register(name, () -> new Item(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)name)))));
    }

    private static DeferredItem<Item> createSwordItem(String name, ToolMaterial material, boolean isFireProof) {
        if (isFireProof) {
            return ITEMS.register(name, () -> new SwordItem(material, material.attackDamageBonus(), material.speed(), new Item.Properties().fireResistant().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)name)))));
        }
        return ITEMS.register(name, () -> new SwordItem(material, material.attackDamageBonus(), material.speed(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)name)))));
    }

    private static DeferredItem<Item> createPickaxeItem(String name, ToolMaterial material, boolean isFireProof) {
        if (isFireProof) {
            return ITEMS.register(name, () -> new PickaxeItem(material, material.attackDamageBonus(), material.speed(), new Item.Properties().fireResistant().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)name)))));
        }
        return ITEMS.register(name, () -> new PickaxeItem(material, material.attackDamageBonus(), material.speed(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)name)))));
    }

    private static DeferredItem<Item> createAxeItem(String name, ToolMaterial material, boolean isFireProof) {
        if (isFireProof) {
            return ITEMS.register(name, () -> new AxeItem(material, material.attackDamageBonus(), material.speed(), new Item.Properties().fireResistant().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)name)))));
        }
        return ITEMS.register(name, () -> new AxeItem(material, material.attackDamageBonus(), material.speed(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)name)))));
    }

    private static DeferredItem<Item> createShovelItem(String name, ToolMaterial material, boolean isFireProof) {
        if (isFireProof) {
            return ITEMS.register(name, () -> new ShovelItem(material, material.attackDamageBonus(), material.speed(), new Item.Properties().fireResistant().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)name)))));
        }
        return ITEMS.register(name, () -> new ShovelItem(material, material.attackDamageBonus(), material.speed(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)name)))));
    }

    private static DeferredItem<Item> createHoeItem(String name, ToolMaterial material, boolean isFireProof) {
        if (isFireProof) {
            return ITEMS.register(name, () -> new HoeItem(material, material.attackDamageBonus(), material.speed(), new Item.Properties().fireResistant().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)name)))));
        }
        return ITEMS.register(name, () -> new HoeItem(material, material.attackDamageBonus(), material.speed(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)name)))));
    }

    private static DeferredItem<Item> createArmorItem(String name, ArmorMaterial material, ArmorType armorType, boolean isFireProof, int durability) {
        if (isFireProof) {
            return ITEMS.register(name, () -> new ArmorItem(material, armorType, new Item.Properties().fireResistant().stacksTo(1).durability(durability).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)name)))));
        }
        return ITEMS.register(name, () -> new ArmorItem(material, armorType, new Item.Properties().stacksTo(1).durability(durability).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)name)))));
    }
}

