/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.model.entity;

import com.tristankechlo.livingthings.client.model.AdvancedEntityModel;
import com.tristankechlo.livingthings.client.renderer.state.ShroomieRenderState;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class ShroomieModel<T extends ShroomieRenderState>
extends AdvancedEntityModel<T> {
    private final ModelPart LegLeft;
    private final ModelPart LegRight;
    private final ModelPart HeadBrown;
    private final ModelPart HeadRed;
    private final ModelPart ArmLeft;
    private final ModelPart ArmRight;

    public ShroomieModel(ModelPart root) {
        super(root);
        ModelPart body = root.getChild("Body");
        this.LegLeft = body.getChild("LegLeft");
        this.LegRight = body.getChild("LegRight");
        this.HeadBrown = body.getChild("HeadBrown");
        this.HeadRed = body.getChild("HeadRed");
        this.ArmLeft = body.getChild("ArmLeft");
        this.ArmRight = body.getChild("ArmRight");
    }

    @Override
    protected void animate(T state, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (((ShroomieRenderState)state).variant == 0) {
            this.HeadBrown.visible = true;
            this.HeadRed.visible = false;
        } else {
            this.HeadBrown.visible = false;
            this.HeadRed.visible = true;
        }
        this.walking1(this.LegLeft, limbSwing, limbSwingAmount);
        this.walking2(this.LegRight, limbSwing, limbSwingAmount);
        this.walking2(this.ArmLeft, limbSwing, limbSwingAmount);
        this.walking1(this.ArmRight, limbSwing, limbSwingAmount);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 18).addBox(-3.0f, -11.0f, -3.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition LegLeft = Body.addOrReplaceChild("LegLeft", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-1.5f, (float)-3.0f, (float)0.0f));
        PartDefinition LegRight = Body.addOrReplaceChild("LegRight", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.5f, (float)-3.0f, (float)0.0f));
        PartDefinition HeadBrown = Body.addOrReplaceChild("HeadBrown", CubeListBuilder.create().texOffs(0, 5).addBox(-5.0f, -3.0f, -5.0f, 10.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-11.0f, (float)0.0f));
        PartDefinition HeadRed = Body.addOrReplaceChild("HeadRed", CubeListBuilder.create().texOffs(0, 4).addBox(-5.0f, -4.0f, -5.0f, 10.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(24, 23).addBox(-3.0f, -7.0f, -3.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-11.0f, (float)0.0f));
        PartDefinition ArmLeft = Body.addOrReplaceChild("ArmLeft", CubeListBuilder.create().texOffs(0, 6).addBox(0.0f, 0.0f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-9.0f, (float)0.0f));
        PartDefinition ArmRight = Body.addOrReplaceChild("ArmRight", CubeListBuilder.create().texOffs(0, 6).mirror().addBox(-1.0f, 0.0f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-3.0f, (float)-9.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)48, (int)32);
    }
}

