/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.neoforge.gen;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import noobanidus.mods.lootr.neoforge.gen.LootrAdvancementGenerator;
import noobanidus.mods.lootr.neoforge.gen.LootrAtlasGenerator;
import noobanidus.mods.lootr.neoforge.gen.LootrBlockEntityTagsProvider;
import noobanidus.mods.lootr.neoforge.gen.LootrBlockTagProvider;
import noobanidus.mods.lootr.neoforge.gen.LootrEntityTagsProvider;
import noobanidus.mods.lootr.neoforge.gen.LootrItemTagsProvider;
import noobanidus.mods.lootr.neoforge.gen.LootrLangProvider;
import noobanidus.mods.lootr.neoforge.gen.LootrLootTableProvider;
import noobanidus.mods.lootr.neoforge.gen.LootrStructureTagsProvider;

@EventBusSubscriber(modid="lootr", bus=EventBusSubscriber.Bus.MOD)
public class LootrDataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = event.getGenerator().getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        generator.addProvider(true, (DataProvider)new LootrAtlasGenerator(output, provider, helper));
        generator.addProvider(true, (DataProvider)new LootrLangProvider(output));
    }

    @SubscribeEvent
    public static void gatherServerData(GatherDataEvent.Server event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = event.getGenerator().getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        LootrBlockTagProvider blocks = new LootrBlockTagProvider(output, provider, helper);
        generator.addProvider(true, (DataProvider)blocks);
        generator.addProvider(true, (DataProvider)new LootrItemTagsProvider(output, provider, blocks.contentsGetter(), helper));
        generator.addProvider(true, (DataProvider)LootrLootTableProvider.create(output, provider));
        generator.addProvider(true, (DataProvider)new LootrEntityTagsProvider(output, provider, helper));
        generator.addProvider(true, (DataProvider)new LootrBlockEntityTagsProvider(output, provider, helper));
        generator.addProvider(true, (DataProvider)new LootrStructureTagsProvider(output, provider, helper));
        generator.addProvider(true, (DataProvider)new AdvancementProvider(output, provider, helper, List.of(new LootrAdvancementGenerator())));
    }
}

