/*
 * Decompiled with CFR 0.152.
 */
package metalfences;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.datafixers.util.Pair;
import com.mt1006.metalfences.MetalFencesBlockAccessor;
import com.mt1006.metalfences.blocks.IronFenceGateBlock;
import com.mt1006.metalfences.blocks.WaxedCopperFenceBlock;
import com.mt1006.metalfences.blocks.WaxedCopperFenceGateBlock;
import com.mt1006.metalfences.blocks.WeatheringCopperFenceBlock;
import com.mt1006.metalfences.blocks.WeatheringCopperFenceGateBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;

@Mod(value="metalfences")
public class MetalFencesMod
extends MetalFencesBlockAccessor {
    public static final String MOD_ID = "metalfences";
    private static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"metalfences");
    private static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"metalfences");
    private static final List<Pair<DeferredHolder<Item, Item>, Item>> creativeTabPairs = new ArrayList<Pair<DeferredHolder<Item, Item>, Item>>();
    public static final DeferredHolder<Block, Block> IRON_FENCE = MetalFencesMod.register("iron_fence", FenceBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.METAL).requiresCorrectToolForDrops().strength(4.0f, 5.0f).sound(SoundType.METAL), Items.IRON_DOOR);
    public static final DeferredHolder<Block, Block> IRON_FENCE_GATE = MetalFencesMod.register("iron_fence_gate", IronFenceGateBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.METAL).requiresCorrectToolForDrops().strength(4.0f, 5.0f).sound(SoundType.METAL), Items.IRON_DOOR);
    public static final DeferredHolder<Block, Block> COPPER_FENCE = MetalFencesMod.register("copper_fence", props -> new WeatheringCopperFenceBlock(WeatheringCopper.WeatherState.UNAFFECTED, (BlockBehaviour.Properties)props), MetalFencesMod.getCopperProps(), Items.COPPER_DOOR);
    public static final DeferredHolder<Block, Block> EXPOSED_COPPER_FENCE = MetalFencesMod.register("exposed_copper_fence", props -> new WeatheringCopperFenceBlock(WeatheringCopper.WeatherState.EXPOSED, (BlockBehaviour.Properties)props), MetalFencesMod.getCopperProps(), Items.EXPOSED_COPPER_DOOR);
    public static final DeferredHolder<Block, Block> WEATHERED_COPPER_FENCE = MetalFencesMod.register("weathered_copper_fence", props -> new WeatheringCopperFenceBlock(WeatheringCopper.WeatherState.WEATHERED, (BlockBehaviour.Properties)props), MetalFencesMod.getCopperProps(), Items.WEATHERED_COPPER_DOOR);
    public static final DeferredHolder<Block, Block> OXIDIZED_COPPER_FENCE = MetalFencesMod.register("oxidized_copper_fence", props -> new WeatheringCopperFenceBlock(WeatheringCopper.WeatherState.OXIDIZED, (BlockBehaviour.Properties)props), MetalFencesMod.getCopperProps(), Items.OXIDIZED_COPPER_DOOR);
    public static final DeferredHolder<Block, Block> WAXED_COPPER_FENCE = MetalFencesMod.register("waxed_copper_fence", WaxedCopperFenceBlock::new, MetalFencesMod.getCopperProps(), Items.WAXED_COPPER_DOOR);
    public static final DeferredHolder<Block, Block> WAXED_EXPOSED_COPPER_FENCE = MetalFencesMod.register("waxed_exposed_copper_fence", WaxedCopperFenceBlock::new, MetalFencesMod.getCopperProps(), Items.WAXED_EXPOSED_COPPER_DOOR);
    public static final DeferredHolder<Block, Block> WAXED_WEATHERED_COPPER_FENCE = MetalFencesMod.register("waxed_weathered_copper_fence", WaxedCopperFenceBlock::new, MetalFencesMod.getCopperProps(), Items.WAXED_WEATHERED_COPPER_DOOR);
    public static final DeferredHolder<Block, Block> WAXED_OXIDIZED_COPPER_FENCE = MetalFencesMod.register("waxed_oxidized_copper_fence", WaxedCopperFenceBlock::new, MetalFencesMod.getCopperProps(), Items.WAXED_OXIDIZED_COPPER_DOOR);
    public static final DeferredHolder<Block, Block> COPPER_FENCE_GATE = MetalFencesMod.register("copper_fence_gate", props -> new WeatheringCopperFenceGateBlock(WeatheringCopper.WeatherState.UNAFFECTED, (BlockBehaviour.Properties)props), MetalFencesMod.getCopperProps(), Items.COPPER_DOOR);
    public static final DeferredHolder<Block, Block> EXPOSED_COPPER_FENCE_GATE = MetalFencesMod.register("exposed_copper_fence_gate", props -> new WeatheringCopperFenceGateBlock(WeatheringCopper.WeatherState.EXPOSED, (BlockBehaviour.Properties)props), MetalFencesMod.getCopperProps(), Items.EXPOSED_COPPER_DOOR);
    public static final DeferredHolder<Block, Block> WEATHERED_COPPER_FENCE_GATE = MetalFencesMod.register("weathered_copper_fence_gate", props -> new WeatheringCopperFenceGateBlock(WeatheringCopper.WeatherState.WEATHERED, (BlockBehaviour.Properties)props), MetalFencesMod.getCopperProps(), Items.WEATHERED_COPPER_DOOR);
    public static final DeferredHolder<Block, Block> OXIDIZED_COPPER_FENCE_GATE = MetalFencesMod.register("oxidized_copper_fence_gate", props -> new WeatheringCopperFenceGateBlock(WeatheringCopper.WeatherState.OXIDIZED, (BlockBehaviour.Properties)props), MetalFencesMod.getCopperProps(), Items.OXIDIZED_COPPER_DOOR);
    public static final DeferredHolder<Block, Block> WAXED_COPPER_FENCE_GATE = MetalFencesMod.register("waxed_copper_fence_gate", WaxedCopperFenceGateBlock::new, MetalFencesMod.getCopperProps(), Items.WAXED_COPPER_DOOR);
    public static final DeferredHolder<Block, Block> WAXED_EXPOSED_COPPER_FENCE_GATE = MetalFencesMod.register("waxed_exposed_copper_fence_gate", WaxedCopperFenceGateBlock::new, MetalFencesMod.getCopperProps(), Items.WAXED_EXPOSED_COPPER_DOOR);
    public static final DeferredHolder<Block, Block> WAXED_WEATHERED_COPPER_FENCE_GATE = MetalFencesMod.register("waxed_weathered_copper_fence_gate", WaxedCopperFenceGateBlock::new, MetalFencesMod.getCopperProps(), Items.WAXED_WEATHERED_COPPER_DOOR);
    public static final DeferredHolder<Block, Block> WAXED_OXIDIZED_COPPER_FENCE_GATE = MetalFencesMod.register("waxed_oxidized_copper_fence_gate", WaxedCopperFenceGateBlock::new, MetalFencesMod.getCopperProps(), Items.WAXED_OXIDIZED_COPPER_DOOR);
    public static final BiMap<ResourceLocation, ResourceLocation> WEATHERING = ImmutableBiMap.of((Object)COPPER_FENCE.getId(), (Object)EXPOSED_COPPER_FENCE.getId(), (Object)EXPOSED_COPPER_FENCE.getId(), (Object)WEATHERED_COPPER_FENCE.getId(), (Object)WEATHERED_COPPER_FENCE.getId(), (Object)OXIDIZED_COPPER_FENCE.getId(), (Object)COPPER_FENCE_GATE.getId(), (Object)EXPOSED_COPPER_FENCE_GATE.getId(), (Object)EXPOSED_COPPER_FENCE_GATE.getId(), (Object)WEATHERED_COPPER_FENCE_GATE.getId(), (Object)WEATHERED_COPPER_FENCE_GATE.getId(), (Object)OXIDIZED_COPPER_FENCE_GATE.getId());
    public static final BiMap<ResourceLocation, ResourceLocation> INVERSE_WEATHERING = WEATHERING.inverse();
    public static final BiMap<ResourceLocation, ResourceLocation> WAXABLES = ImmutableBiMap.of((Object)COPPER_FENCE.getId(), (Object)WAXED_COPPER_FENCE.getId(), (Object)EXPOSED_COPPER_FENCE.getId(), (Object)WAXED_EXPOSED_COPPER_FENCE.getId(), (Object)WEATHERED_COPPER_FENCE.getId(), (Object)WAXED_WEATHERED_COPPER_FENCE.getId(), (Object)OXIDIZED_COPPER_FENCE.getId(), (Object)WAXED_OXIDIZED_COPPER_FENCE.getId(), (Object)COPPER_FENCE_GATE.getId(), (Object)WAXED_COPPER_FENCE_GATE.getId(), (Object)EXPOSED_COPPER_FENCE_GATE.getId(), (Object)WAXED_EXPOSED_COPPER_FENCE_GATE.getId(), (Object)WEATHERED_COPPER_FENCE_GATE.getId(), (Object)WAXED_WEATHERED_COPPER_FENCE_GATE.getId(), (Object)OXIDIZED_COPPER_FENCE_GATE.getId(), (Object)WAXED_OXIDIZED_COPPER_FENCE_GATE.getId());
    public static final BiMap<ResourceLocation, ResourceLocation> UNWAXABLES = WAXABLES.inverse();

    public MetalFencesMod(IEventBus modEventBus) {
        MetalFencesBlockAccessor.ACCESSOR = this;
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        modEventBus.addListener(this::addToCreativeTab);
    }

    private static DeferredHolder<Block, Block> register(String id, Function<BlockBehaviour.Properties, Block> blockSupplier, BlockBehaviour.Properties properties, Item nextInTab) {
        DeferredBlock registryObject = BLOCKS.registerBlock(id, blockSupplier, properties);
        DeferredItem item = ITEMS.registerItem(id, arg_0 -> MetalFencesMod.lambda$register$8((DeferredHolder)registryObject, arg_0));
        creativeTabPairs.add((Pair<DeferredHolder<Item, Item>, Item>)Pair.of((Object)item, (Object)nextInTab));
        return registryObject;
    }

    private void addToCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().equals(CreativeModeTabs.BUILDING_BLOCKS)) {
            for (Pair<DeferredHolder<Item, Item>, Item> pair : creativeTabPairs) {
                event.insertBefore(new ItemStack((ItemLike)pair.getSecond()), new ItemStack((ItemLike)((DeferredHolder)pair.getFirst()).get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }
    }

    @Nullable
    private Block getFromMap(Map<ResourceLocation, ResourceLocation> map, Block block) {
        if (!BuiltInRegistries.BLOCK.containsValue((Object)block)) {
            return null;
        }
        ResourceLocation newBlockId = map.get(BuiltInRegistries.BLOCK.getKey((Object)block));
        if (newBlockId == null || !BuiltInRegistries.BLOCK.containsKey(newBlockId)) {
            return null;
        }
        Holder.Reference ref = BuiltInRegistries.BLOCK.get(newBlockId).orElse(null);
        return ref != null ? (Block)ref.value() : null;
    }

    private static BlockBehaviour.Properties getCopperProps() {
        return BlockBehaviour.Properties.of().mapColor(Blocks.COPPER_BLOCK.defaultMapColor()).strength(3.0f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.COPPER);
    }

    @Override
    @Nullable
    public Block getNextWeathered(Block block) {
        return this.getFromMap((Map<ResourceLocation, ResourceLocation>)WEATHERING, block);
    }

    @Override
    @Nullable
    public Block getNextUnweathered(Block block) {
        return this.getFromMap((Map<ResourceLocation, ResourceLocation>)INVERSE_WEATHERING, block);
    }

    @Override
    @Nullable
    public Block getWaxed(Block block) {
        return this.getFromMap((Map<ResourceLocation, ResourceLocation>)WAXABLES, block);
    }

    @Override
    @Nullable
    public Block getUnwaxed(Block block) {
        return this.getFromMap((Map<ResourceLocation, ResourceLocation>)UNWAXABLES, block);
    }

    private static /* synthetic */ Item lambda$register$8(DeferredHolder registryObject, Item.Properties props) {
        return new BlockItem((Block)registryObject.get(), props.useBlockDescriptionPrefix());
    }
}

