/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.minetraps.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xxrexraptorxx.minetraps.registry.ModBlocks;
import xxrexraptorxx.minetraps.utils.Config;

public class BlockBarbedWire
extends HalfTransparentBlock {
    private static final VoxelShape RENDER_SHAPE = Shapes.empty();

    public BlockBarbedWire(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        entity.makeStuckInBlock(state, new Vec3(0.25, (double)0.05f, 0.25));
        if (!level.isClientSide) {
            if (((Boolean)Config.BARBED_WIRE_DESTROY_ITEMS.get()).booleanValue()) {
                if (this == ModBlocks.BARBED_WIRE.get()) {
                    entity.hurt(level.damageSources().generic(), (float)((Integer)Config.BARBED_WIRE_DAMAGE.get()).intValue());
                }
                if (this == ModBlocks.RAZOR_WIRE.get()) {
                    entity.hurt(level.damageSources().generic(), (float)((Integer)Config.RAZOR_WIRE_DAMAGE.get()).intValue());
                }
            } else if (entity instanceof LivingEntity) {
                if (this == ModBlocks.BARBED_WIRE.get()) {
                    entity.hurt(level.damageSources().generic(), (float)((Integer)Config.BARBED_WIRE_DAMAGE.get()).intValue());
                }
                if (this == ModBlocks.RAZOR_WIRE.get()) {
                    entity.hurt(level.damageSources().generic(), (float)((Integer)Config.RAZOR_WIRE_DAMAGE.get()).intValue());
                }
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }
}

