/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.minetraps.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xxrexraptorxx.minetraps.utils.Config;

public class BlockBarbedWireFence
extends CrossCollisionBlock {
    public BlockBarbedWireFence(BlockBehaviour.Properties properties) {
        super(1.0f, 1.0f, 16.0f, 16.0f, 16.0f, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level blockgetter = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        BlockPos blockpos1 = blockpos.north();
        BlockPos blockpos2 = blockpos.south();
        BlockPos blockpos3 = blockpos.west();
        BlockPos blockpos4 = blockpos.east();
        BlockState blockstate = blockgetter.getBlockState(blockpos1);
        BlockState blockstate1 = blockgetter.getBlockState(blockpos2);
        BlockState blockstate2 = blockgetter.getBlockState(blockpos3);
        BlockState blockstate3 = blockgetter.getBlockState(blockpos4);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.connectsTo(blockstate, blockstate.isFaceSturdy((BlockGetter)blockgetter, blockpos1, Direction.SOUTH))))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.connectsTo(blockstate1, blockstate1.isFaceSturdy((BlockGetter)blockgetter, blockpos2, Direction.NORTH))))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.connectsTo(blockstate2, blockstate2.isFaceSturdy((BlockGetter)blockgetter, blockpos3, Direction.EAST))))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.connectsTo(blockstate3, blockstate3.isFaceSturdy((BlockGetter)blockgetter, blockpos4, Direction.WEST))))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return direction.getAxis().isHorizontal() ? (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(this.connectsTo(neighborState, neighborState.isFaceSturdy((BlockGetter)level, pos, direction.getOpposite())))) : super.updateShape(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public boolean skipRendering(BlockState state, BlockState state2, Direction direction) {
        if (state2.is((Block)this)) {
            if (!direction.getAxis().isHorizontal()) {
                return true;
            }
            if (((Boolean)state.getValue((Property)PROPERTY_BY_DIRECTION.get(direction))).booleanValue() && ((Boolean)state2.getValue((Property)PROPERTY_BY_DIRECTION.get(direction.getOpposite()))).booleanValue()) {
                return true;
            }
        }
        return super.skipRendering(state, state2, direction);
    }

    public final boolean connectsTo(BlockState state, boolean p_54219_) {
        return !BlockBarbedWireFence.isExceptionForConnection((BlockState)state) && p_54219_ || state.getBlock() instanceof IronBarsBlock || state.getBlock() instanceof BlockBarbedWireFence || state.is(BlockTags.WALLS);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> state) {
        state.add(new Property[]{NORTH, EAST, WEST, SOUTH, WATERLOGGED});
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        entity.makeStuckInBlock(state, new Vec3(0.25, (double)0.05f, 0.25));
        if (!level.isClientSide) {
            if (((Boolean)Config.BARBED_WIRE_DESTROY_ITEMS.get()).booleanValue()) {
                entity.hurt(level.damageSources().generic(), (float)((Integer)Config.BARBED_WIRE_FENCE_DAMAGE.get()).intValue());
            } else if (entity instanceof LivingEntity) {
                entity.hurt(level.damageSources().generic(), (float)((Integer)Config.BARBED_WIRE_FENCE_DAMAGE.get()).intValue());
            }
        }
    }

    protected MapCodec<? extends CrossCollisionBlock> codec() {
        return null;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

