/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.minetraps.world;

import com.mojang.authlib.GameProfile;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Scanner;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.VersionChecker;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforgespi.language.IModInfo;
import xxrexraptorxx.minetraps.main.MineTraps;
import xxrexraptorxx.minetraps.utils.Config;

@EventBusSubscriber(modid="minetraps", bus=EventBusSubscriber.Bus.GAME)
public class Events {
    private static boolean hasShownUp = false;
    private static final HttpClient HTTP_CLIENT = HttpClient.newHttpClient();

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Pre event) {
        ModContainer modContainer;
        if (Config.UPDATE_CHECKER != null && ((Boolean)Config.UPDATE_CHECKER.get()).booleanValue() && !hasShownUp && Minecraft.getInstance().screen == null && (modContainer = (ModContainer)ModList.get().getModContainerById("minetraps").orElse(null)) != null) {
            VersionChecker.CheckResult versionCheckResult = VersionChecker.getResult((IModInfo)modContainer.getModInfo());
            if (versionCheckResult.status() == VersionChecker.Status.OUTDATED || versionCheckResult.status() == VersionChecker.Status.BETA_OUTDATED) {
                MutableComponent url = Component.literal((String)(String.valueOf(ChatFormatting.GREEN) + "Click here to update!"));
                url.withStyle(url.getStyle().withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/minetraps")));
                Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.BLUE) + "A newer version of " + String.valueOf(ChatFormatting.YELLOW) + "MineTraps" + String.valueOf(ChatFormatting.BLUE) + " is available!")), false);
                Minecraft.getInstance().player.displayClientMessage((Component)url, false);
                hasShownUp = true;
            } else if (versionCheckResult.status() == VersionChecker.Status.FAILED) {
                MineTraps.LOGGER.error("MineTraps's version checker failed!");
                hasShownUp = true;
            }
        }
    }

    @SubscribeEvent
    public static void SupporterRewards(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        Level level = player.level();
        if (((Boolean)Config.PATREON_REWARDS.get()).booleanValue()) {
            try {
                ServerPlayer serverPlayer;
                URI SUPPORTER_URI = URI.create("https://raw.githubusercontent.com/XxRexRaptorxX/Patreons/main/Supporter");
                URI PREMIUM_SUPPORTER_URI = URI.create("https://raw.githubusercontent.com/XxRexRaptorxX/Patreons/main/Premium%20Supporter");
                URI ELITE_URI = URI.create("https://raw.githubusercontent.com/XxRexRaptorxX/Patreons/main/Elite");
                if (!player.getInventory().contains(new ItemStack((ItemLike)Items.PAPER)) && (serverPlayer = (ServerPlayer)player).getStats().getValue(Stats.CUSTOM, (Object)Stats.PLAY_TIME) < 5) {
                    if (Events.SupporterCheck(SUPPORTER_URI, player)) {
                        Events.giveSupporterReward(player, level);
                    }
                    if (Events.SupporterCheck(PREMIUM_SUPPORTER_URI, player)) {
                        Events.givePremiumSupporterReward(player, level);
                    }
                    if (Events.SupporterCheck(ELITE_URI, player)) {
                        Events.giveEliteReward(player);
                    }
                }
            }
            catch (Exception e) {
                MineTraps.LOGGER.error("An unexpected error occurred while getting the Supporter URI lists", (Throwable)e);
            }
        }
    }

    private static boolean SupporterCheck(URI uri, Player player) {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(uri).GET().build();
            HttpResponse<String> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            List<String> supporterList = List.of(response.body().split("\\R"));
            return supporterList.contains(player.getName().getString());
        }
        catch (Exception e) {
            MineTraps.LOGGER.error("Failed to fetch or process supporter list from URI: {}", (Object)uri, (Object)e);
            return false;
        }
    }

    private static void giveSupporterReward(Player player, Level level) {
        ItemStack certificate = new ItemStack((ItemLike)Items.PAPER);
        certificate.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Thank you for supporting me in my work!").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)" - XxRexRaptorxX").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GREEN)));
        ItemStack reward = new ItemStack((ItemLike)Items.PLAYER_HEAD);
        GameProfile profile = new GameProfile(player.getUUID(), player.getName().getString());
        reward.set(DataComponents.PROFILE, (Object)new ResolvableProfile(profile));
        level.playSound(null, player.blockPosition(), SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 0.5f, level.random.nextFloat() * 0.15f + 0.8f);
        player.getInventory().add(reward);
        player.getInventory().add(certificate);
    }

    private static void givePremiumSupporterReward(Player player, Level level) {
        ItemStack reward = new ItemStack((ItemLike)Items.DIAMOND_SWORD, 1);
        Registry enchantmentsRegistry = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        reward.enchant((Holder)enchantmentsRegistry.getOrThrow(Enchantments.MENDING), 1);
        reward.enchant((Holder)enchantmentsRegistry.getOrThrow(Enchantments.SHARPNESS), 3);
        reward.set(DataComponents.ENCHANTMENTS, (Object)((ItemEnchantments)reward.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)));
        player.getInventory().add(reward);
    }

    private static void giveEliteReward(Player player) {
        ItemStack star = new ItemStack((ItemLike)Items.NETHER_STAR);
        star.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Elite Star"));
        player.getInventory().add(star);
    }

    private static boolean SupporterCheck(URL url, Player player) {
        try {
            Scanner scanner = new Scanner(url.openStream());
            List<String> supporterList = scanner.tokens().toList();
            for (String name : supporterList) {
                if (!player.getName().getString().equals(name)) continue;
                return true;
            }
            scanner.close();
        }
        catch (MalformedURLException e) {
            MineTraps.LOGGER.error("Supporter list URL not found! >>{}", (Object)url);
        }
        catch (Exception e) {
            MineTraps.LOGGER.error("An unexpected error occurred while checking supporter list", (Throwable)e);
        }
        return false;
    }
}

