/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.client;

import io.github.davidqf555.minecraft.multiverse.client.colors.MultiverseColorHelper;
import io.github.davidqf555.minecraft.multiverse.common.world.DimensionHelper;
import io.github.davidqf555.minecraft.multiverse.registration.ParticleTypeRegistry;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ARGB;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public final class ClientHelper {
    private ClientHelper() {
    }

    public static void addRiftParticles(Optional<ResourceKey<Level>> dim, Vec3 center) {
        ClientLevel world = Minecraft.getInstance().level;
        if (world != null) {
            ResourceKey from = dim.orElseGet(() -> DimensionHelper.randomMultiverseDimension(world.getRandom(), Optional.of(world.dimension())));
            int color = MultiverseColorHelper.getColor((Level)world, (ResourceKey<Level>)from);
            world.addParticle((ParticleOptions)ParticleTypeRegistry.RIFT.get(), center.x(), center.y(), center.z(), (double)ARGB.red((int)color) / 255.0, (double)ARGB.green((int)color) / 255.0, (double)ARGB.blue((int)color) / 255.0);
        }
    }

    public static void addRiftExplosionParticles(Optional<ResourceKey<Level>> dim, Vec3 center) {
        ClientLevel world = Minecraft.getInstance().level;
        if (world != null) {
            ResourceKey from = dim.orElseGet(() -> DimensionHelper.randomMultiverseDimension(world.getRandom(), Optional.of(world.dimension())));
            int color = MultiverseColorHelper.getColor((Level)world, (ResourceKey<Level>)from);
            world.addParticle((ParticleOptions)ParticleTypeRegistry.RIFT_EXPLOSION_EMITTER.get(), center.x(), center.y(), center.z(), (double)ARGB.red((int)color) / 255.0, (double)ARGB.green((int)color) / 255.0, (double)ARGB.blue((int)color) / 255.0);
        }
    }
}

