/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.client.colors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.davidqf555.minecraft.multiverse.client.colors.MultiverseColorHelper;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public final class KaleiditeCurrentColor {
    private KaleiditeCurrentColor() {
    }

    public static class Item
    implements ItemTintSource {
        public static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"multiverse", (String)"kaleidite_current");
        public static final MapCodec<Item> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ExtraCodecs.ARGB_COLOR_CODEC.fieldOf("default").forGetter(color -> color.defaultColor)).apply((Applicative)inst, Item::new));
        private final int defaultColor;

        protected Item(int defaultColor) {
            this.defaultColor = defaultColor;
        }

        public int calculate(ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity) {
            if (world != null) {
                return MultiverseColorHelper.getColor((Level)world);
            }
            return this.defaultColor;
        }

        public MapCodec<? extends ItemTintSource> type() {
            return CODEC;
        }
    }

    public static class Block
    implements BlockColor {
        public static final Block INSTANCE = new Block();

        protected Block() {
        }

        public int getColor(BlockState state, @Nullable BlockAndTintGetter tint, @Nullable BlockPos pos, int layer) {
            ClientLevel level = Minecraft.getInstance().level;
            return level == null ? -1 : MultiverseColorHelper.getColor((Level)level);
        }
    }
}

