/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.client.colors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.davidqf555.minecraft.multiverse.client.colors.MultiverseColorHelper;
import io.github.davidqf555.minecraft.multiverse.common.world.items.MultiversalToolHelper;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class KaleiditeTargetColor
implements ItemTintSource {
    public static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"multiverse", (String)"kaleidite_target");
    public static final MapCodec<KaleiditeTargetColor> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ExtraCodecs.ARGB_COLOR_CODEC.fieldOf("default").forGetter(color -> color.defaultColor)).apply((Applicative)inst, KaleiditeTargetColor::new));
    private final int defaultColor;

    protected KaleiditeTargetColor(int defaultColor) {
        this.defaultColor = defaultColor;
    }

    public int calculate(ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity) {
        if (world != null) {
            return MultiverseColorHelper.getColor((Level)world, MultiversalToolHelper.getTarget(stack));
        }
        return this.defaultColor;
    }

    public MapCodec<? extends ItemTintSource> type() {
        return CODEC;
    }
}

