/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.client.particles;

import io.github.davidqf555.minecraft.multiverse.client.ClientConfigs;
import io.github.davidqf555.minecraft.multiverse.client.ShaderHelper;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import org.jetbrains.annotations.Nullable;

public class RiftExplosionParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    protected RiftExplosionParticle(ClientLevel pLevel, double pX, double pY, double pZ, SpriteSet pSprites) {
        super(pLevel, pX, pY, pZ);
        this.sprites = pSprites;
        this.hasPhysics = false;
        this.setAlpha((float)((Double)ClientConfigs.INSTANCE.riftMaxOpacity.get()).doubleValue());
        this.lifetime = 6 + this.random.nextInt(4);
        this.quadSize = 2.0f - this.random.nextFloat();
        this.setSpriteFromAge(pSprites);
    }

    public ParticleRenderType getRenderType() {
        return (Boolean)ClientConfigs.INSTANCE.vanillaOnly.get() != false ? ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT : ShaderHelper.RIFT_PARTICLE_TYPE;
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
    }

    protected int getLightColor(float pPartialTick) {
        return 0xF000F0;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double dX, double dY, double dZ) {
            RiftExplosionParticle particle = new RiftExplosionParticle(level, x, y, z, this.sprites);
            particle.setColor((float)dX, (float)dY, (float)dZ);
            return particle;
        }
    }
}

