/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.client.particles;

import io.github.davidqf555.minecraft.multiverse.client.ClientConfigs;
import io.github.davidqf555.minecraft.multiverse.client.ShaderHelper;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class RiftParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    protected RiftParticle(ClientLevel world, double x, double y, double z, SpriteSet sprites) {
        super(world, x, y, z);
        this.lifetime = 10 + this.random.nextInt(6);
        this.hasPhysics = false;
        this.sprites = sprites;
        this.scale(10.0f);
        this.setAlpha((float)((Double)ClientConfigs.INSTANCE.riftMaxOpacity.get()).doubleValue());
        this.setSpriteFromAge(sprites);
    }

    public ParticleRenderType getRenderType() {
        return (Boolean)ClientConfigs.INSTANCE.vanillaOnly.get() != false ? ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT : ShaderHelper.RIFT_PARTICLE_TYPE;
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
    }

    protected int getLightColor(float pPartialTick) {
        return 0xF000F0;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double dX, double dY, double dZ) {
            RiftParticle particle = new RiftParticle(level, x, y, z, this.sprites);
            particle.setColor((float)dX, (float)dY, (float)dZ);
            return particle;
        }
    }
}

