/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.davidqf555.minecraft.multiverse.client.ClientConfigs;
import io.github.davidqf555.minecraft.multiverse.client.ShaderHelper;
import io.github.davidqf555.minecraft.multiverse.client.colors.MultiverseColorHelper;
import io.github.davidqf555.minecraft.multiverse.common.world.blocks.RiftTileEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class RiftTileEntityRenderer
implements BlockEntityRenderer<RiftTileEntity> {
    public void render(RiftTileEntity entity, float partial, PoseStack matrixStack, MultiBufferSource buffer, int overlay, int packedLight) {
        int i;
        int base = entity.hasLevel() ? MultiverseColorHelper.getColor(entity.getLevel(), entity.getTarget()) : -1;
        VertexConsumer consumer = buffer.getBuffer((Boolean)ClientConfigs.INSTANCE.vanillaOnly.get() != false ? ShaderHelper.RIFT_VANILLA : ShaderHelper.RIFT);
        Vec3[][] visual = entity.getVisual();
        Vec3 offset = entity.getNormal().normalize().scale(((Double)ClientConfigs.INSTANCE.riftZOffset.get()).doubleValue());
        double min = (Double)ClientConfigs.INSTANCE.riftMinOpacity.get();
        double max = (Double)ClientConfigs.INSTANCE.riftMaxOpacity.get();
        int[] colors = new int[visual.length];
        double destA = 0.0;
        for (i = visual.length - 1; i >= 0; --i) {
            int alpha;
            if (destA >= 1.0) {
                alpha = 255;
            } else {
                double target = this.getAlphaFactor(i, visual.length, min, max);
                alpha = (int)((target - destA) * 255.0 / (1.0 - destA));
                destA += (double)alpha * (1.0 - destA) / 255.0;
            }
            colors[i] = base & 0xFFFFFF | alpha << 24;
        }
        matrixStack.pushPose();
        for (i = visual.length - 1; i >= 0; --i) {
            this.drawPolygon(consumer, matrixStack, visual[i], offset, colors[i], true);
        }
        matrixStack.popPose();
        matrixStack.pushPose();
        for (i = visual.length - 1; i >= 0; --i) {
            this.drawPolygon(consumer, matrixStack, visual[i], offset, colors[i], false);
        }
        matrixStack.popPose();
    }

    protected double getAlphaFactor(int layer, int layers, double min, double max) {
        return layers <= 1 ? max : Mth.lerp((double)((double)layer / ((double)layers - 1.0)), (double)max, (double)min);
    }

    private void drawPolygon(VertexConsumer consumer, PoseStack pose, Vec3[] vertices, Vec3 offset, int color, boolean forward) {
        switch (vertices.length) {
            case 3: {
                this.drawQuad(consumer, pose, vertices[0], vertices[0], vertices[1], vertices[2], offset, color, forward);
                break;
            }
            case 5: {
                this.drawQuad(consumer, pose, vertices[0], vertices[0], vertices[3], vertices[4], offset, color, forward);
            }
            case 4: {
                this.drawQuad(consumer, pose, vertices[0], vertices[1], vertices[2], vertices[3], offset, color, forward);
                break;
            }
            case 6: {
                this.drawQuad(consumer, pose, vertices[0], vertices[1], vertices[2], vertices[3], offset, color, forward);
                this.drawQuad(consumer, pose, vertices[0], vertices[3], vertices[4], vertices[5], offset, color, forward);
                break;
            }
            default: {
                int jump = (vertices.length - 4) / 2;
                this.drawQuad(consumer, pose, vertices[0], vertices[1], vertices[jump + 2], vertices[jump + 3], offset, color, forward);
                Vec3[] first = new Vec3[jump + 2];
                first[0] = vertices[jump + 2];
                first[1] = vertices[1];
                System.arraycopy(vertices, 2, first, 2, jump);
                this.drawPolygon(consumer, pose, first, offset, color, forward);
                Vec3[] second = new Vec3[vertices.length - jump - 2];
                second[0] = vertices[0];
                second[1] = vertices[jump + 3];
                System.arraycopy(vertices, jump + 4, second, 2, vertices.length - jump - 4);
                this.drawPolygon(consumer, pose, second, offset, color, forward);
            }
            case 0: 
            case 1: 
            case 2: 
        }
    }

    private void drawQuad(VertexConsumer consumer, PoseStack stack, Vec3 p1, Vec3 p2, Vec3 p3, Vec3 p4, Vec3 offset, int color, boolean forward) {
        Matrix4f pose = stack.last().pose();
        if (forward) {
            consumer.addVertex(pose, (float)p4.x(), (float)p4.y(), (float)p4.z()).setColor(color);
            consumer.addVertex(pose, (float)p3.x(), (float)p3.y(), (float)p3.z()).setColor(color);
            consumer.addVertex(pose, (float)p2.x(), (float)p2.y(), (float)p2.z()).setColor(color);
            consumer.addVertex(pose, (float)p1.x(), (float)p1.y(), (float)p1.z()).setColor(color);
            stack.translate(offset.x(), offset.y(), offset.z());
        } else {
            consumer.addVertex(pose, (float)p1.x(), (float)p1.y(), (float)p1.z()).setColor(color);
            consumer.addVertex(pose, (float)p2.x(), (float)p2.y(), (float)p2.z()).setColor(color);
            consumer.addVertex(pose, (float)p3.x(), (float)p3.y(), (float)p3.z()).setColor(color);
            consumer.addVertex(pose, (float)p4.x(), (float)p4.y(), (float)p4.z()).setColor(color);
            stack.translate(-offset.x(), -offset.y(), -offset.z());
        }
    }

    public int getViewDistance() {
        return (Integer)ClientConfigs.INSTANCE.riftRenderDistance.get();
    }
}

