/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.serialization.MapCodec;
import net.minecraft.client.model.ShieldModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.special.NoDataSpecialModelRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import org.jetbrains.annotations.Nullable;

public class WarpShieldRenderer
implements NoDataSpecialModelRenderer {
    public static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"multiverse", (String)"warp_shield");
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"multiverse", (String)"textures/item/warp_shield.png");
    private final ShieldModel model;

    protected WarpShieldRenderer(ShieldModel model) {
        this.model = model;
    }

    public void render(ItemDisplayContext context, PoseStack pose, MultiBufferSource buffer, int light, int overlay, boolean foil) {
        pose.pushPose();
        pose.scale(1.0f, -1.0f, -1.0f);
        VertexConsumer vertexconsumer = ItemRenderer.getFoilBuffer((MultiBufferSource)buffer, (RenderType)this.model.renderType(TEXTURE), (boolean)true, (boolean)foil);
        this.model.renderToBuffer(pose, vertexconsumer, light, overlay);
        pose.popPose();
    }

    public static class Unbaked
    implements SpecialModelRenderer.Unbaked {
        public static final MapCodec<Unbaked> CODEC = MapCodec.unit((Object)new Unbaked());

        protected Unbaked() {
        }

        @Nullable
        public SpecialModelRenderer<?> bake(EntityModelSet set) {
            return new WarpShieldRenderer(new ShieldModel(set.bakeLayer(ModelLayers.SHIELD)));
        }

        public MapCodec<? extends Unbaked> type() {
            return CODEC;
        }
    }
}

