/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ServerConfigs {
    public static final ServerConfigs INSTANCE;
    public static final ModConfigSpec SPEC;
    public final ModConfigSpec.DoubleValue travelerSpawnChance;
    public final ModConfigSpec.DoubleValue minRiftWidth;
    public final ModConfigSpec.DoubleValue maxRiftWidth;
    public final ModConfigSpec.DoubleValue fireworkRate;
    public final ModConfigSpec.DoubleValue fireRate;
    public final ModConfigSpec.DoubleValue minSpawnRadius;
    public final ModConfigSpec.DoubleValue maxSpawnRadius;
    public final ModConfigSpec.DoubleValue spawnOffset;
    public final ModConfigSpec.DoubleValue temperatureScale;
    public final ModConfigSpec.DoubleValue humidityScale;
    public final ModConfigSpec.DoubleValue swordMinWidth;
    public final ModConfigSpec.DoubleValue swordMaxWidth;
    public final ModConfigSpec.DoubleValue swordWidthRate;
    public final ModConfigSpec.DoubleValue swordMinHeight;
    public final ModConfigSpec.DoubleValue swordMaxHeight;
    public final ModConfigSpec.DoubleValue swordHeightRate;
    public final ModConfigSpec.DoubleValue swordSpawnDistance;
    public final ModConfigSpec.DoubleValue coreRange;
    public final ModConfigSpec.DoubleValue bountyRate;
    public final ModConfigSpec.DoubleValue conquerorMinSpawnDist;
    public final ModConfigSpec.DoubleValue conquerorMaxSpawnDist;
    public final ModConfigSpec.DoubleValue conquerorMaxSpawnHDist;
    public final ModConfigSpec.DoubleValue conquerorDistanceThreshold;
    public final ModConfigSpec.DoubleValue shieldRange;
    public final ModConfigSpec.IntValue maxDimensions;
    public final ModConfigSpec.IntValue riftRange;
    public final ModConfigSpec.IntValue minRiftHeight;
    public final ModConfigSpec.IntValue maxRiftHeight;
    public final ModConfigSpec.IntValue spawnPeriod;
    public final ModConfigSpec.IntValue spawnCount;
    public final ModConfigSpec.IntValue slowFalling;
    public final ModConfigSpec.IntValue swordMinCharge;
    public final ModConfigSpec.IntValue swordCooldown;
    public final ModConfigSpec.IntValue armorMinOffset;
    public final ModConfigSpec.IntValue armorMaxOffset;
    public final ModConfigSpec.IntValue armorMaxSpawn;
    public final ModConfigSpec.IntValue armorSpawnPeriod;
    public final ModConfigSpec.IntValue doppelTimeout;
    public final ModConfigSpec.IntValue travelerMaxDoppel;
    public final ModConfigSpec.IntValue travelerDoppelPeriod;
    public final ModConfigSpec.IntValue travelerMinRange;
    public final ModConfigSpec.IntValue travelerMaxRange;
    public final ModConfigSpec.IntValue conquerorMobThreshold;
    public final ModConfigSpec.IntValue conquerorCastTime;
    public final ModConfigSpec.IntValue conquerorCooldown;
    public final ModConfigSpec.IntValue conquerorSlowFallingDuration;
    public final ModConfigSpec.IntValue conquerorSlowFallingAmplifier;
    public final ModConfigSpec.IntValue conquerorSpawnCount;
    public final ModConfigSpec.IntValue warpRingCooldown;

    public ServerConfigs(ModConfigSpec.Builder builder) {
        builder.comment("Multiverse server-side configuration").push("Dimensions");
        this.maxDimensions = builder.comment("This is the number of Multiverse dimensions that rifts will generate for. ").defineInRange("max", 25, 1, Integer.MAX_VALUE);
        builder.pop().push("Rifts");
        this.riftRange = builder.comment("This is the range that is scanned for existing rifts using points of interest. ").defineInRange("range", 128, 0, Integer.MAX_VALUE);
        this.slowFalling = builder.comment("This is the number of ticks that players get slow falling for after exiting a rift. Set to 0 if don't want slow falling. ").defineInRange("slowFalling", 600, 0, Integer.MAX_VALUE);
        builder.comment("Only for artificially placed rifts (Modify configured/placed feature for naturally generated rifts)").push("Size");
        this.minRiftWidth = builder.comment("This is the minimum width of artificially placed rifts. ").defineInRange("minRiftWidth", 1.0, 0.0, Double.MAX_VALUE);
        this.maxRiftWidth = builder.comment("This is the maximum width of artificially placed rifts. This should be greater or equal to minRiftWidth. ").defineInRange("maxRiftWidth", 4.0, 0.0, Double.MAX_VALUE);
        this.minRiftHeight = builder.comment("This is the minimum height of artificially placed rifts. ").defineInRange("minRiftHeight", 16, 0, Integer.MAX_VALUE);
        this.maxRiftHeight = builder.comment("This is the maximum height of artificially placed rifts. This should be greater or equal to minRiftHeight. ").defineInRange("maxRiftHeight", 48, 0, Integer.MAX_VALUE);
        builder.pop(2).push("PrismaticSword");
        this.swordCooldown = builder.comment("This is the cooldown of the sword's rift spawning in ticks. ").defineInRange("swordCooldown", 500, 0, Integer.MAX_VALUE);
        this.swordSpawnDistance = builder.comment("This is the distance in blocks from the player's eyes in the direction they look in that the center of the rift spawns from the sword. ").defineInRange("swordSpawnDistance", 2.5, -1.7976931348623157E308, Double.MAX_VALUE);
        this.swordMinCharge = builder.comment("This is the minimum number of ticks that the sword needs to be charged in order to spawn a rift. ").defineInRange("swordMinCharge", 20, 0, Integer.MAX_VALUE);
        this.swordMinWidth = builder.comment("This is the initial width of rifts spawned by the sword when charged the minimum charge. ").defineInRange("swordMinWidth", 1.0, 0.0, Double.MAX_VALUE);
        this.swordMaxWidth = builder.comment("This is the max width of rifts spawned by the sword. Should be at least swordMinWidth. ").defineInRange("swordMaxWidth", 8.0, 0.0, Double.MAX_VALUE);
        this.swordWidthRate = builder.comment("This is the rate that the width of rifts spawned by the sword grow in blocks per tick charged. ").defineInRange("swordWidthRate", 0.011666666666666667, 0.0, Double.MAX_VALUE);
        this.swordMinHeight = builder.comment("This is the initial height of rifts spawned by the sword when charged the minimum charge. ").defineInRange("swordMinHeight", 16.0, 0.0, Double.MAX_VALUE);
        this.swordMaxHeight = builder.comment("This is the max height of rifts spawned by the sword. Should be at least swordMinHeight. ").defineInRange("swordMaxHeight", 64.0, 0.0, Double.MAX_VALUE);
        this.swordHeightRate = builder.comment("This is the rate that the height of rifts spawned by the sword grow in blocks per tick charged. ").defineInRange("swordHeightRate", 0.08, 0.0, Double.MAX_VALUE);
        builder.pop().push("KaleiditeCrossbow");
        this.fireworkRate = builder.comment("This is the chance that fireworks are spawned when shooting an arrow. ").defineInRange("fireworkRate", 0.2, 0.0, 1.0);
        this.fireRate = builder.comment("This is the chance that a spawned arrow is on fire. ").defineInRange("fireRate", 0.2, 0.0, 1.0);
        this.minSpawnRadius = builder.comment("This is the minimum distance in blocks that a projectile can spawn from the shooter. ").defineInRange("minSpawnRadius", 4.0, 0.0, Double.MAX_VALUE);
        this.maxSpawnRadius = builder.comment("This is the maximum distance in blocks that a projectile can spawn from the shooter. This must be at least minSpawnRadius. ").defineInRange("maxSpawnRadius", 10.0, 0.0, Double.MAX_VALUE);
        this.spawnOffset = builder.comment("This is the offset that projectiles are spawned relative to the direction they are shot in blocks. ").defineInRange("spawnOffset", -2.0, -1.7976931348623157E308, Double.MAX_VALUE);
        this.spawnPeriod = builder.comment("This is the period in ticks that projectiles are spawned").defineInRange("spawnPeriod", 5, 1, Integer.MAX_VALUE);
        this.spawnCount = builder.comment("This is the number of projectiles spawned every time the crossbow is shot. ").defineInRange("spawnCount", 20, 0, Integer.MAX_VALUE);
        builder.pop().push("KaleiditeChestplate");
        this.armorMinOffset = builder.comment("This is the minimum distance in blocks that a doppelganger will spawn from the wearer. ").defineInRange("armorMinOffset", 1, 0, Integer.MAX_VALUE);
        this.armorMaxOffset = builder.comment("This is the maximum distance in blocks that a doppelganger will spawn from the wearer. This should be at least armorMinOffset. ").defineInRange("armorMaxOffset", 8, 0, Integer.MAX_VALUE);
        this.armorMaxSpawn = builder.comment("This is the maximum number of doppelgangers the wearer can spawn at once. ").defineInRange("armorMaxSpawn", 8, 0, Integer.MAX_VALUE);
        this.armorSpawnPeriod = builder.comment("This is the period in ticks that the wearer spawns doppelgangers when in combat. ").defineInRange("armorSpawnPeriod", 40, 1, Integer.MAX_VALUE);
        builder.pop().push("Traveler");
        this.travelerSpawnChance = builder.comment("This is the chance that a Traveler spawns per random tick for each rift block. ").defineInRange("travelerSpawnChance", 1.0E-4, 0.0, 1.0);
        this.travelerMinRange = builder.comment("This is the minimum distance in blocks that the traveler spawns doppelgangers and teleports when hurt. ").defineInRange("travelerMinRange", 8, 0, Integer.MAX_VALUE);
        this.travelerMaxRange = builder.comment("This is the maximum distance in blocks that the traveler spawns doppelgangers and teleports when hurt. This should be at least travelerMinRange. ").defineInRange("travelerMaxRange", 16, 0, Integer.MAX_VALUE);
        this.travelerMaxDoppel = builder.comment("This is the maximum number of doppelgangers a traveler can spawn at once. ").defineInRange("travelerMaxDoppel", 10, 0, Integer.MAX_VALUE);
        this.travelerDoppelPeriod = builder.comment("This is the period in ticks that the traveler spawns doppelgangers. ").defineInRange("travelerDoppelPeriod", 20, 1, Integer.MAX_VALUE);
        this.bountyRate = builder.comment("This is the chance that killing a traveler gives the bounty effect.").defineInRange("bountyRate", 0.3, 0.0, 1.0);
        builder.pop().push("Conqueror");
        this.conquerorMinSpawnDist = builder.comment("This is the minimum vertical distance in blocks that a conqueror will spawn a rift above its target. ").defineInRange("conquerorMinSpawnDist", 8.0, 0.0, Double.MAX_VALUE);
        this.conquerorMaxSpawnDist = builder.comment("This is the maximum vertical distance in blocks that a conqueror will spawn a rift above its target. Must at least conquerorMinSpawnDist. ").defineInRange("conquerorMaxSpawnDist", 32.0, 0.0, Double.MAX_VALUE);
        this.conquerorMaxSpawnHDist = builder.comment("This is the maximum horizontal distance in blocks that a conqueror will spawn a rift above its target. ").defineInRange("conquerorMaxSpawnHDist", 32.0, 0.0, Double.MAX_VALUE);
        this.conquerorMobThreshold = builder.comment("This is the number of raiders near (within the same raid or within targeting range) the conqueror before it stops spawning rifts. ").defineInRange("conquerorMobThreshold", 16, 0, Integer.MAX_VALUE);
        this.conquerorDistanceThreshold = builder.comment("This is the minimum distance in blocks that the conqueror will summon rifts. ").defineInRange("conquerorDistanceThreshold", 6.0, 0.0, Double.MAX_VALUE);
        this.conquerorCastTime = builder.comment("This is the time in ticks that it takes for a conqueror to summon a rift. ").defineInRange("conquerorCastTime", 100, 0, Integer.MAX_VALUE);
        this.conquerorCooldown = builder.comment("This is the cooldown of a conquerors summoning rifts in ticks. ").defineInRange("conquerorCooldown", 100, 0, Integer.MAX_VALUE);
        this.conquerorSlowFallingDuration = builder.comment("This is the duration in ticks of the slow falling effect given to raiders spawned by a conqueror. Set to 0 to not give any effect.").defineInRange("conquerorSlowFallingDuration", 200, 0, Integer.MAX_VALUE);
        this.conquerorSlowFallingAmplifier = builder.comment("This is the level of the slow falling effect given to raiders spawned by a conqueror. Set to 0 to not give any effect.").defineInRange("conquerorSlowFallingAmplifier", 1, 0, Integer.MAX_VALUE);
        this.conquerorSpawnCount = builder.comment("This is the number of raiders that spawn from every rift the conqueror summons. ").defineInRange("conquerorSpawnCount", 3, 0, Integer.MAX_VALUE);
        builder.pop().push("Terrablender").comment("The following settings only apply if Terrablender is included. ");
        this.temperatureScale = builder.comment("This is the scale of the Gaussian random temperature offset applied to biome parameters to mitigate collisions. ").defineInRange("temperatureScale", 0.15, 0.0, Double.MAX_VALUE);
        this.humidityScale = builder.comment("This is the scale of the Gaussian random humidity offset applied to biome parameters to mitigate collisions. ").defineInRange("humidityScale", 0.15, 0.0, Double.MAX_VALUE);
        builder.pop().push("Miscellaneous");
        this.doppelTimeout = builder.comment("This is the time in ticks after exiting combat that before doppelgangers despawn. ").defineInRange("doppelTimeout", 600, 0, Integer.MAX_VALUE);
        this.coreRange = builder.comment("This is the distance in blocks that the kaleidite core searches for connected rifts to remove. ").defineInRange("coreRange", 50.0, 0.0, Double.MAX_VALUE);
        this.shieldRange = builder.comment("This is the range in blocks that the warp shield item warps projectiles. ").defineInRange("shieldRange", 3.0, 0.0, Double.MAX_VALUE);
        this.warpRingCooldown = builder.comment("This is the cooldown of the warp ring in ticks. ").defineInRange("warpRingCooldown", 600, 0, Integer.MAX_VALUE);
        builder.pop();
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(ServerConfigs::new);
        INSTANCE = (ServerConfigs)pair.getLeft();
        SPEC = (ModConfigSpec)pair.getRight();
    }
}

