/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.integration;

import io.github.davidqf555.minecraft.multiverse.common.ServerConfigs;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.MultiverseSurfaceRuleData;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.MultiverseType;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.biomes.MultiverseBiomes;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.biomes.VanillaMultiverseBiomes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.SurfaceRules;
import terrablender.api.EndBiomeRegistry;
import terrablender.api.RegionType;
import terrablender.api.Regions;
import terrablender.api.SurfaceRuleManager;
import terrablender.worldgen.surface.NamespacedSurfaceRuleSource;

public class TerraBlenderBiomes
implements MultiverseBiomes {
    private static final List<Climate.ParameterPoint> ZERO = List.of(Climate.parameters((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
    private final List<SurfaceRules.RuleSource> overworld;
    private final List<SurfaceRules.RuleSource> nether;
    private final List<SurfaceRules.RuleSource> end;
    private final Set<ResourceKey<Biome>> overworldBiomes;
    private final Set<ResourceKey<Biome>> netherBiomes;
    private final Set<ResourceKey<Biome>> endBiomes;
    private final Map<ResourceKey<Biome>, List<Climate.ParameterPoint>> parameters = new HashMap<ResourceKey<Biome>, List<Climate.ParameterPoint>>();

    public TerraBlenderBiomes(Registry<Biome> registry) {
        this.overworld = TerraBlenderBiomes.getSurface(SurfaceRuleManager.RuleCategory.OVERWORLD);
        this.nether = TerraBlenderBiomes.getSurface(SurfaceRuleManager.RuleCategory.NETHER);
        this.end = TerraBlenderBiomes.getSurface(SurfaceRuleManager.RuleCategory.END);
        this.parameters.putAll(VanillaMultiverseBiomes.getParameters());
        Map<ResourceKey<Biome>, List<Climate.ParameterPoint>> overworld = TerraBlenderBiomes.getBiomes(registry, RegionType.OVERWORLD);
        this.overworldBiomes = overworld.keySet();
        Map<ResourceKey<Biome>, List<Climate.ParameterPoint>> nether = TerraBlenderBiomes.getBiomes(registry, RegionType.NETHER);
        this.netherBiomes = nether.keySet();
        Map<ResourceKey<Biome>, List<Climate.ParameterPoint>> end = TerraBlenderBiomes.getEndBiomesParameters();
        this.endBiomes = end.keySet();
        this.parameters.putAll(nether);
        this.parameters.putAll(overworld);
        this.parameters.putAll(end);
    }

    private static Map<ResourceKey<Biome>, List<Climate.ParameterPoint>> getBiomes(Registry<Biome> registry, RegionType type) {
        HashMap<ResourceKey<Biome>, List<Climate.ParameterPoint>> map = new HashMap<ResourceKey<Biome>, List<Climate.ParameterPoint>>();
        Regions.get((RegionType)type).forEach(region -> region.addBiomes(registry, pair -> {
            List<Climate.ParameterPoint> add;
            ResourceKey key = (ResourceKey)pair.getSecond();
            if (map.containsKey(key)) {
                add = (List)map.get(key);
            } else {
                add = new ArrayList();
                map.put(key, add);
            }
            add.add((Climate.ParameterPoint)pair.getFirst());
        }));
        return map;
    }

    private static Map<ResourceKey<Biome>, List<Climate.ParameterPoint>> getEndBiomesParameters() {
        HashMap<ResourceKey<Biome>, List<Climate.ParameterPoint>> map = new HashMap<ResourceKey<Biome>, List<Climate.ParameterPoint>>();
        for (WeightedEntry.Wrapper entry : EndBiomeRegistry.getIslandBiomes()) {
            map.put((ResourceKey)entry.data(), TerraBlenderBiomes.getEndParameters(-1.0f, -0.21875f));
        }
        for (WeightedEntry.Wrapper entry : EndBiomeRegistry.getEdgeBiomes()) {
            map.put((ResourceKey)entry.data(), TerraBlenderBiomes.getEndParameters(-0.21875f, -0.0625f));
        }
        for (WeightedEntry.Wrapper entry : EndBiomeRegistry.getMidlandsBiomes()) {
            map.put((ResourceKey<Biome>)((ResourceKey)entry.data()), TerraBlenderBiomes.getEndParameters(-0.0625f, 0.25f));
        }
        for (WeightedEntry.Wrapper entry : EndBiomeRegistry.getHighlandsBiomes()) {
            map.put((ResourceKey<Biome>)((ResourceKey)entry.data()), TerraBlenderBiomes.getEndParameters(0.25f, 1.0f));
        }
        return map;
    }

    private static List<Climate.ParameterPoint> getEndParameters(float min, float max) {
        return List.of(Climate.parameters((Climate.Parameter)Climate.Parameter.point((float)0.0f), (Climate.Parameter)Climate.Parameter.point((float)0.0f), (Climate.Parameter)Climate.Parameter.point((float)0.0f), (Climate.Parameter)Climate.Parameter.span((float)min, (float)max), (Climate.Parameter)Climate.Parameter.point((float)0.0f), (Climate.Parameter)Climate.Parameter.point((float)0.0f), (float)0.0f));
    }

    private static List<SurfaceRules.RuleSource> getSurface(SurfaceRuleManager.RuleCategory category) {
        return ((NamespacedSurfaceRuleSource)SurfaceRuleManager.getNamespacedRules((SurfaceRuleManager.RuleCategory)category, null)).sources().entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("minecraft")).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @Override
    public Set<ResourceKey<Biome>> getOverworldBiomes() {
        return this.overworldBiomes;
    }

    @Override
    public Set<ResourceKey<Biome>> getNetherBiomes() {
        return this.netherBiomes;
    }

    @Override
    public Set<ResourceKey<Biome>> getEndBiomes() {
        return this.endBiomes;
    }

    private static Climate.ParameterPoint offset(Climate.ParameterPoint base, RandomSource random) {
        float tOffset = (float)(random.nextGaussian() * (Double)ServerConfigs.INSTANCE.temperatureScale.get());
        float hOffset = (float)(random.nextGaussian() * (Double)ServerConfigs.INSTANCE.humidityScale.get());
        Climate.Parameter temperature = Climate.Parameter.span((float)Mth.clamp((float)(Climate.unquantizeCoord((long)base.temperature().min()) + tOffset), (float)-2.0f, (float)2.0f), (float)Mth.clamp((float)(Climate.unquantizeCoord((long)base.temperature().min()) + tOffset), (float)-2.0f, (float)2.0f));
        Climate.Parameter humidity = Climate.Parameter.span((float)Mth.clamp((float)(Climate.unquantizeCoord((long)base.humidity().min()) + hOffset), (float)-2.0f, (float)2.0f), (float)Mth.clamp((float)(Climate.unquantizeCoord((long)base.humidity().min()) + hOffset), (float)-2.0f, (float)2.0f));
        return new Climate.ParameterPoint(temperature, humidity, base.continentalness(), base.erosion(), base.depth(), base.weirdness(), base.offset());
    }

    @Override
    public List<Climate.ParameterPoint> getParameters(ResourceKey<Biome> biome, RandomSource random) {
        List<Climate.ParameterPoint> original = this.parameters.getOrDefault(biome, ZERO);
        ArrayList<Climate.ParameterPoint> offset = new ArrayList<Climate.ParameterPoint>();
        for (Climate.ParameterPoint base : original) {
            offset.add(TerraBlenderBiomes.offset(base, random));
        }
        return offset;
    }

    @Override
    public SurfaceRules.RuleSource createSurface(boolean floor, boolean ceiling, MultiverseType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case MultiverseType.OVERWORLD -> MultiverseSurfaceRuleData.overworld(floor && !ceiling, ceiling, floor, this.overworld);
            case MultiverseType.NETHER -> MultiverseSurfaceRuleData.nether(ceiling, floor, this.nether);
            case MultiverseType.END -> MultiverseSurfaceRuleData.end(ceiling, floor, this.end);
        };
    }
}

