/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world;

import io.github.davidqf555.minecraft.multiverse.common.ServerConfigs;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;

public final class DimensionHelper {
    private DimensionHelper() {
    }

    public static ResourceKey<Level> randomMultiverseDimension(RandomSource random, Optional<ResourceKey<Level>> exclude) {
        Optional multiverse = exclude.flatMap(DimensionHelper::getIndex);
        int size = (Integer)ServerConfigs.INSTANCE.maxDimensions.get() + 1;
        if (multiverse.isPresent()) {
            --size;
        }
        int rand = random.nextInt(size);
        if (multiverse.isPresent() && rand >= (Integer)multiverse.get()) {
            ++rand;
        }
        return DimensionHelper.getRegistryKey(rand);
    }

    public static long getSeed(long overworld, int index) {
        return overworld + 80000L * (long)index;
    }

    public static Vec3 translate(Vec3 pos, DimensionType from, DimensionType to, boolean logical) {
        int fromHeight = logical ? from.logicalHeight() : from.height();
        int toHeight = logical ? to.logicalHeight() : to.height();
        double factorY = Mth.clamp((double)((pos.y() - (double)from.minY()) / (double)fromHeight), (double)0.0, (double)1.0);
        double y = (double)to.minY() + (double)toHeight * factorY;
        double scale = DimensionType.getTeleportationScale((DimensionType)from, (DimensionType)to);
        return new Vec3(pos.x() * scale, y, pos.z() * scale);
    }

    public static ResourceKey<Level> getRegistryKey(int index) {
        if (index == 0) {
            return Level.OVERWORLD;
        }
        return ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)DimensionHelper.getResourceLocation(index));
    }

    public static ResourceLocation getResourceLocation(int index) {
        return ResourceLocation.fromNamespaceAndPath((String)"multiverse", (String)String.valueOf(index));
    }

    public static Optional<Integer> getIndex(ResourceKey<Level> world) {
        if (world.equals((Object)Level.OVERWORLD)) {
            return Optional.of(0);
        }
        if (world.location().getNamespace().equals("multiverse")) {
            try {
                return Optional.of(Integer.parseInt(world.location().getPath()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }
}

