/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world;

import io.github.davidqf555.minecraft.multiverse.common.ServerConfigs;
import io.github.davidqf555.minecraft.multiverse.common.advancements.EnterRiftTrigger;
import io.github.davidqf555.minecraft.multiverse.common.packets.RiftExplosionParticlesPacket;
import io.github.davidqf555.minecraft.multiverse.common.world.DimensionHelper;
import io.github.davidqf555.minecraft.multiverse.common.world.RiftPlacementHelper;
import io.github.davidqf555.minecraft.multiverse.common.world.blocks.RiftBlock;
import io.github.davidqf555.minecraft.multiverse.common.world.blocks.RiftTileEntity;
import io.github.davidqf555.minecraft.multiverse.registration.BlockRegistry;
import io.github.davidqf555.minecraft.multiverse.registration.POIRegistry;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public final class RiftHelper {
    public static final TeleportTransition.PostTeleportTransition TRIGGER = entity -> {
        if (entity instanceof ServerPlayer) {
            EnterRiftTrigger.INSTANCE.trigger((ServerPlayer)entity);
        }
    };
    public static final TeleportTransition.PostTeleportTransition SLOW_FALLING = entity -> {
        int duration;
        if (entity instanceof LivingEntity && (duration = ((Integer)ServerConfigs.INSTANCE.slowFalling.get()).intValue()) > 0) {
            ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, duration, 1, false, true));
        }
    };
    public static final TeleportTransition.PostTeleportTransition CLEAR = entity -> {
        AABB box = AABB.ofSize((Vec3)entity.position().add(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0), (double)entity.getBbWidth(), (double)entity.getBbHeight(), (double)entity.getBbWidth());
        BlockPos.betweenClosedStream((AABB)box).filter(p -> !entity.level().isOutsideBuildHeight(p) && RiftPlacementHelper.ReplacementType.DESTROY.canReplace((LevelReader)entity.level(), (BlockPos)p, entity.level().getBlockState(p))).forEach(p -> entity.level().destroyBlock(p, true));
    };

    private RiftHelper() {
    }

    public static Optional<BlockPos> getClosestRift(ServerLevel world, ResourceKey<Level> target, BlockPos center, int distance) {
        PoiManager manager = world.getPoiManager();
        manager.ensureLoadedAndValid((LevelReader)world, center, distance);
        return manager.getInSquare(arg_0 -> POIRegistry.RIFT.equals(arg_0), center, distance, PoiManager.Occupancy.ANY).map(PoiRecord::getPos).filter(block -> {
            BlockEntity tile = world.getBlockEntity(block);
            return tile instanceof RiftTileEntity && ((RiftTileEntity)tile).getTarget().equals((Object)target);
        }).min(Comparator.comparingDouble(arg_0 -> ((BlockPos)center).distSqr(arg_0)));
    }

    public static Vec3 getOrCreateRift(ServerLevel world, ResourceKey<Level> target, Vec3 center, boolean temporary, int distance, RiftPlacementHelper.ReplacementType replacement) {
        return RiftHelper.getClosestRift(world, target, BlockPos.containing((Position)center), distance).map(Vec3::atCenterOf).orElseGet(() -> {
            RiftHelper.placeRandomRift(world, target, temporary, center, replacement);
            return center;
        });
    }

    public static void placeRandomRift(ServerLevel world, ResourceKey<Level> target, boolean temporary, double width, double height, Vec3 center, Vec3 normal, float angle, RiftPlacementHelper.ReplacementType replacement) {
        RiftHelper.doRiftSpawnEffect(world, BlockPos.containing((Position)center), Optional.of(target));
        RiftPlacementHelper.place((LevelWriter)world, (LevelReader)world, (BlockState)((RiftBlock)((Object)BlockRegistry.RIFT.get())).defaultBlockState().setValue((Property)RiftBlock.TEMPORARY, (Comparable)Boolean.valueOf(temporary)), target, center, normal, angle, width, height, replacement);
    }

    public static void placeRandomRift(ServerLevel world, ResourceKey<Level> target, boolean temporary, Vec3 center, Vec3 normal, float angle, RiftPlacementHelper.ReplacementType replacement) {
        RandomSource rand = world.getRandom();
        double minWidth = (Double)ServerConfigs.INSTANCE.minRiftWidth.get();
        double maxWidth = (Double)ServerConfigs.INSTANCE.maxRiftWidth.get();
        double minHeight = ((Integer)ServerConfigs.INSTANCE.minRiftHeight.get()).intValue();
        double maxHeight = ((Integer)ServerConfigs.INSTANCE.maxRiftHeight.get()).intValue();
        double width = minWidth + rand.nextDouble() * (maxWidth - minWidth);
        double height = minHeight + rand.nextDouble() * (maxHeight - minHeight);
        RiftHelper.placeRandomRift(world, target, temporary, width, height, center, normal, angle, replacement);
    }

    public static void placeRandomRift(ServerLevel world, ResourceKey<Level> target, boolean temporary, Vec3 center, RiftPlacementHelper.ReplacementType replacement) {
        RandomSource rand = world.getRandom();
        Vec3 normal = new Vec3(rand.nextDouble(), rand.nextDouble(), rand.nextDouble());
        float angle = rand.nextFloat() * 180.0f;
        RiftHelper.placeRandomRift(world, target, temporary, center, normal, angle, replacement);
    }

    public static void placeRandomRift(ServerLevel world, boolean temporary, Vec3 center, boolean mob) {
        RiftPlacementHelper.ReplacementType replacement = !mob || world.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) ? RiftPlacementHelper.ReplacementType.DESTROY : RiftPlacementHelper.ReplacementType.NONE;
        RiftHelper.placeRandomRift(world, DimensionHelper.randomMultiverseDimension(world.getRandom(), Optional.of(world.dimension())), temporary, center, replacement);
    }

    public static void doRiftSpawnEffect(ServerLevel world, BlockPos pos, Optional<ResourceKey<Level>> target) {
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)world, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new RiftExplosionParticlesPacket(target, Vec3.atCenterOf((Vec3i)pos)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.END_GATEWAY_SPAWN, SoundSource.BLOCKS, 10.0f, 0.7f + (world.random.nextFloat() - world.random.nextFloat()) * 0.14f);
        world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.GLASS_BREAK, SoundSource.BLOCKS, 6.0f, 0.8f + (world.random.nextFloat() - world.random.nextFloat()) * 0.14f);
    }

    public static void destroyRift(ServerLevel world, BlockPos pos, @Nullable Entity entity) {
        BlockEntity be = world.getBlockEntity(pos);
        if (be instanceof RiftTileEntity) {
            ResourceKey<Level> target = ((RiftTileEntity)be).getTarget();
            RiftHelper.doRiftSpawnEffect(world, pos, Optional.of(target));
            ServerLevel w = world.getServer().getLevel(target);
            if (w != null) {
                RiftHelper.destroyConnectedRifts((Level)world, w, pos, entity);
            }
        }
        RiftHelper.destroyConnectedBlocks((Level)world, pos, (Double)ServerConfigs.INSTANCE.coreRange.get(), entity);
    }

    private static void destroyConnectedBlocks(Level world, BlockPos start, double distance, @Nullable Entity entity) {
        int index = 0;
        LinkedList<BlockPos> list = new LinkedList<BlockPos>();
        list.add(start);
        while (index < list.size()) {
            int n = index++;
            BlockPos pos = (BlockPos)list.get(n);
            if (!(pos.distSqr((Vec3i)start) <= distance * distance) || !(world.getBlockState(pos).getBlock() instanceof RiftBlock)) continue;
            BlockPos.betweenClosedStream((BlockPos)pos.relative(Direction.DOWN).relative(Direction.WEST).relative(Direction.SOUTH), (BlockPos)pos.relative(Direction.UP).relative(Direction.EAST).relative(Direction.NORTH)).filter(p -> !list.contains(p)).map(BlockPos::immutable).forEach(list::add);
            world.destroyBlock(pos, true, entity);
        }
    }

    private static void destroyConnectedRifts(Level from, ServerLevel target, BlockPos start, @Nullable Entity entity) {
        Vec3 pos = DimensionHelper.translate(Vec3.atCenterOf((Vec3i)start), from.dimensionType(), target.dimensionType(), true);
        RiftHelper.getClosestRift(target, (ResourceKey<Level>)from.dimension(), BlockPos.containing((Position)pos), (Integer)ServerConfigs.INSTANCE.riftRange.get()).ifPresent(b -> {
            RiftHelper.doRiftSpawnEffect(target, b, Optional.of(from.dimension()));
            RiftHelper.destroyConnectedBlocks((Level)target, b, (Double)ServerConfigs.INSTANCE.coreRange.get(), entity);
        });
    }
}

